/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.VolumeSpecification;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VolumeSpecificationMarshaller {
    private static final MarshallingInfo<String> VOLUMETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeType").isBinary(false).build();
    private static final MarshallingInfo<Integer> IOPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Iops").isBinary(false).build();
    private static final MarshallingInfo<Integer> SIZEINGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeInGB").isBinary(false).build();
    private static final VolumeSpecificationMarshaller INSTANCE = new VolumeSpecificationMarshaller();

    private VolumeSpecificationMarshaller() {
    }

    public static VolumeSpecificationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VolumeSpecification volumeSpecification, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)volumeSpecification, (String)"volumeSpecification");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)volumeSpecification.volumeType(), VOLUMETYPE_BINDING);
            protocolMarshaller.marshall((Object)volumeSpecification.iops(), IOPS_BINDING);
            protocolMarshaller.marshall((Object)volumeSpecification.sizeInGB(), SIZEINGB_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

