/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.SpotProvisioningSpecification;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SpotProvisioningSpecificationMarshaller {
    private static final MarshallingInfo<Integer> TIMEOUTDURATIONMINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeoutDurationMinutes").isBinary(false).build();
    private static final MarshallingInfo<String> TIMEOUTACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeoutAction").isBinary(false).build();
    private static final MarshallingInfo<Integer> BLOCKDURATIONMINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BlockDurationMinutes").isBinary(false).build();
    private static final SpotProvisioningSpecificationMarshaller INSTANCE = new SpotProvisioningSpecificationMarshaller();

    private SpotProvisioningSpecificationMarshaller() {
    }

    public static SpotProvisioningSpecificationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SpotProvisioningSpecification spotProvisioningSpecification, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)spotProvisioningSpecification, (String)"spotProvisioningSpecification");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)spotProvisioningSpecification.timeoutDurationMinutes(), TIMEOUTDURATIONMINUTES_BINDING);
            protocolMarshaller.marshall((Object)spotProvisioningSpecification.timeoutActionAsString(), TIMEOUTACTION_BINDING);
            protocolMarshaller.marshall((Object)spotProvisioningSpecification.blockDurationMinutes(), BLOCKDURATIONMINUTES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

