/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.JobFlowInstancesConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobFlowInstancesConfigMarshaller {
    private static final MarshallingInfo<String> MASTERINSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MasterInstanceType").isBinary(false).build();
    private static final MarshallingInfo<String> SLAVEINSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SlaveInstanceType").isBinary(false).build();
    private static final MarshallingInfo<Integer> INSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceCount").isBinary(false).build();
    private static final MarshallingInfo<List> INSTANCEGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceGroups").isBinary(false).build();
    private static final MarshallingInfo<List> INSTANCEFLEETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceFleets").isBinary(false).build();
    private static final MarshallingInfo<String> EC2KEYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ec2KeyName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PLACEMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Placement").isBinary(false).build();
    private static final MarshallingInfo<Boolean> KEEPJOBFLOWALIVEWHENNOSTEPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeepJobFlowAliveWhenNoSteps").isBinary(false).build();
    private static final MarshallingInfo<Boolean> TERMINATIONPROTECTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TerminationProtected").isBinary(false).build();
    private static final MarshallingInfo<String> HADOOPVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HadoopVersion").isBinary(false).build();
    private static final MarshallingInfo<String> EC2SUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ec2SubnetId").isBinary(false).build();
    private static final MarshallingInfo<List> EC2SUBNETIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ec2SubnetIds").isBinary(false).build();
    private static final MarshallingInfo<String> EMRMANAGEDMASTERSECURITYGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmrManagedMasterSecurityGroup").isBinary(false).build();
    private static final MarshallingInfo<String> EMRMANAGEDSLAVESECURITYGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmrManagedSlaveSecurityGroup").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICEACCESSSECURITYGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceAccessSecurityGroup").isBinary(false).build();
    private static final MarshallingInfo<List> ADDITIONALMASTERSECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdditionalMasterSecurityGroups").isBinary(false).build();
    private static final MarshallingInfo<List> ADDITIONALSLAVESECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdditionalSlaveSecurityGroups").isBinary(false).build();
    private static final JobFlowInstancesConfigMarshaller INSTANCE = new JobFlowInstancesConfigMarshaller();

    private JobFlowInstancesConfigMarshaller() {
    }

    public static JobFlowInstancesConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobFlowInstancesConfig jobFlowInstancesConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)jobFlowInstancesConfig, (String)"jobFlowInstancesConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.masterInstanceType(), MASTERINSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.slaveInstanceType(), SLAVEINSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.instanceCount(), INSTANCECOUNT_BINDING);
            protocolMarshaller.marshall(jobFlowInstancesConfig.instanceGroups(), INSTANCEGROUPS_BINDING);
            protocolMarshaller.marshall(jobFlowInstancesConfig.instanceFleets(), INSTANCEFLEETS_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.ec2KeyName(), EC2KEYNAME_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.placement(), PLACEMENT_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.keepJobFlowAliveWhenNoSteps(), KEEPJOBFLOWALIVEWHENNOSTEPS_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.terminationProtected(), TERMINATIONPROTECTED_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.hadoopVersion(), HADOOPVERSION_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.ec2SubnetId(), EC2SUBNETID_BINDING);
            protocolMarshaller.marshall(jobFlowInstancesConfig.ec2SubnetIds(), EC2SUBNETIDS_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.emrManagedMasterSecurityGroup(), EMRMANAGEDMASTERSECURITYGROUP_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.emrManagedSlaveSecurityGroup(), EMRMANAGEDSLAVESECURITYGROUP_BINDING);
            protocolMarshaller.marshall((Object)jobFlowInstancesConfig.serviceAccessSecurityGroup(), SERVICEACCESSSECURITYGROUP_BINDING);
            protocolMarshaller.marshall(jobFlowInstancesConfig.additionalMasterSecurityGroups(), ADDITIONALMASTERSECURITYGROUPS_BINDING);
            protocolMarshaller.marshall(jobFlowInstancesConfig.additionalSlaveSecurityGroups(), ADDITIONALSLAVESECURITYGROUPS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

