/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.InstanceGroupModifyConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceGroupModifyConfigMarshaller {
    private static final MarshallingInfo<String> INSTANCEGROUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceGroupId").isBinary(false).build();
    private static final MarshallingInfo<Integer> INSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceCount").isBinary(false).build();
    private static final MarshallingInfo<List> EC2INSTANCEIDSTOTERMINATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EC2InstanceIdsToTerminate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SHRINKPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShrinkPolicy").isBinary(false).build();
    private static final InstanceGroupModifyConfigMarshaller INSTANCE = new InstanceGroupModifyConfigMarshaller();

    private InstanceGroupModifyConfigMarshaller() {
    }

    public static InstanceGroupModifyConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceGroupModifyConfig instanceGroupModifyConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceGroupModifyConfig, (String)"instanceGroupModifyConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instanceGroupModifyConfig.instanceGroupId(), INSTANCEGROUPID_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupModifyConfig.instanceCount(), INSTANCECOUNT_BINDING);
            protocolMarshaller.marshall(instanceGroupModifyConfig.ec2InstanceIdsToTerminate(), EC2INSTANCEIDSTOTERMINATE_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupModifyConfig.shrinkPolicy(), SHRINKPOLICY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

