/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.InstanceGroupDetail;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceGroupDetailMarshaller {
    private static final MarshallingInfo<String> INSTANCEGROUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceGroupId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> MARKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Market").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceRole").isBinary(false).build();
    private static final MarshallingInfo<String> BIDPRICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BidPrice").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").isBinary(false).build();
    private static final MarshallingInfo<Integer> INSTANCEREQUESTCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceRequestCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> INSTANCERUNNINGCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceRunningCount").isBinary(false).build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").isBinary(false).build();
    private static final MarshallingInfo<String> LASTSTATECHANGEREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastStateChangeReason").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDateTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartDateTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> READYDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReadyDateTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndDateTime").isBinary(false).build();
    private static final InstanceGroupDetailMarshaller INSTANCE = new InstanceGroupDetailMarshaller();

    private InstanceGroupDetailMarshaller() {
    }

    public static InstanceGroupDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceGroupDetail instanceGroupDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceGroupDetail, (String)"instanceGroupDetail");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instanceGroupDetail.instanceGroupId(), INSTANCEGROUPID_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupDetail.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupDetail.marketAsString(), MARKET_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupDetail.instanceRoleAsString(), INSTANCEROLE_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupDetail.bidPrice(), BIDPRICE_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupDetail.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupDetail.instanceRequestCount(), INSTANCEREQUESTCOUNT_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupDetail.instanceRunningCount(), INSTANCERUNNINGCOUNT_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupDetail.stateAsString(), STATE_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupDetail.lastStateChangeReason(), LASTSTATECHANGEREASON_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupDetail.creationDateTime(), CREATIONDATETIME_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupDetail.startDateTime(), STARTDATETIME_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupDetail.readyDateTime(), READYDATETIME_BINDING);
            protocolMarshaller.marshall((Object)instanceGroupDetail.endDateTime(), ENDDATETIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

