/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.InstanceFleet;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceFleetMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEFLEETTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceFleetType").isBinary(false).build();
    private static final MarshallingInfo<Integer> TARGETONDEMANDCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetOnDemandCapacity").isBinary(false).build();
    private static final MarshallingInfo<Integer> TARGETSPOTCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetSpotCapacity").isBinary(false).build();
    private static final MarshallingInfo<Integer> PROVISIONEDONDEMANDCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionedOnDemandCapacity").isBinary(false).build();
    private static final MarshallingInfo<Integer> PROVISIONEDSPOTCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionedSpotCapacity").isBinary(false).build();
    private static final MarshallingInfo<List> INSTANCETYPESPECIFICATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceTypeSpecifications").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LAUNCHSPECIFICATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LaunchSpecifications").isBinary(false).build();
    private static final InstanceFleetMarshaller INSTANCE = new InstanceFleetMarshaller();

    private InstanceFleetMarshaller() {
    }

    public static InstanceFleetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceFleet instanceFleet, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceFleet, (String)"instanceFleet");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instanceFleet.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)instanceFleet.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)instanceFleet.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)instanceFleet.instanceFleetTypeAsString(), INSTANCEFLEETTYPE_BINDING);
            protocolMarshaller.marshall((Object)instanceFleet.targetOnDemandCapacity(), TARGETONDEMANDCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)instanceFleet.targetSpotCapacity(), TARGETSPOTCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)instanceFleet.provisionedOnDemandCapacity(), PROVISIONEDONDEMANDCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)instanceFleet.provisionedSpotCapacity(), PROVISIONEDSPOTCAPACITY_BINDING);
            protocolMarshaller.marshall(instanceFleet.instanceTypeSpecifications(), INSTANCETYPESPECIFICATIONS_BINDING);
            protocolMarshaller.marshall((Object)instanceFleet.launchSpecifications(), LAUNCHSPECIFICATIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

