/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.CancelStepsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CancelStepsRequestModelMarshaller {
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").isBinary(false).build();
    private static final MarshallingInfo<List> STEPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StepIds").isBinary(false).build();
    private static final CancelStepsRequestModelMarshaller INSTANCE = new CancelStepsRequestModelMarshaller();

    private CancelStepsRequestModelMarshaller() {
    }

    public static CancelStepsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CancelStepsRequest cancelStepsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)cancelStepsRequest), (String)"cancelStepsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)cancelStepsRequest.clusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall(cancelStepsRequest.stepIds(), STEPIDS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

