/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.emr.EmrClient;
import software.amazon.awssdk.services.emr.model.InstanceGroup;
import software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest;
import software.amazon.awssdk.services.emr.model.ListInstanceGroupsResponse;

public class ListInstanceGroupsIterable
implements SdkIterable<ListInstanceGroupsResponse> {
    private final EmrClient client;
    private final ListInstanceGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInstanceGroupsIterable(EmrClient client, ListInstanceGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInstanceGroupsResponseFetcher();
    }

    public Iterator<ListInstanceGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceGroup> instanceGroups() {
        Function<ListInstanceGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceGroups() != null) {
                return response.instanceGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListInstanceGroupsIterable resume(ListInstanceGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListInstanceGroupsIterable(this.client, (ListInstanceGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListInstanceGroupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListInstanceGroupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListInstanceGroupsResponseFetcher
    implements SyncPageFetcher<ListInstanceGroupsResponse> {
        private ListInstanceGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceGroupsResponse previousPage) {
            return previousPage.marker() != null && !SdkAutoConstructList.class.isInstance(previousPage.marker()) && !SdkAutoConstructMap.class.isInstance(previousPage.marker());
        }

        public ListInstanceGroupsResponse nextPage(ListInstanceGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceGroupsIterable.this.client.listInstanceGroups(ListInstanceGroupsIterable.this.firstRequest);
            }
            return ListInstanceGroupsIterable.this.client.listInstanceGroups((ListInstanceGroupsRequest)((Object)ListInstanceGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

