/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.emr.EmrAsyncClient;
import software.amazon.awssdk.services.emr.model.InstanceFleet;
import software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest;
import software.amazon.awssdk.services.emr.model.ListInstanceFleetsResponse;

public class ListInstanceFleetsPublisher
implements SdkPublisher<ListInstanceFleetsResponse> {
    private final EmrAsyncClient client;
    private final ListInstanceFleetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInstanceFleetsPublisher(EmrAsyncClient client, ListInstanceFleetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInstanceFleetsPublisher(EmrAsyncClient client, ListInstanceFleetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInstanceFleetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInstanceFleetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstanceFleet> instanceFleets() {
        Function<ListInstanceFleetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceFleets() != null) {
                return response.instanceFleets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInstanceFleetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListInstanceFleetsPublisher resume(ListInstanceFleetsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListInstanceFleetsPublisher(this.client, (ListInstanceFleetsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListInstanceFleetsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListInstanceFleetsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListInstanceFleetsResponseFetcher
    implements AsyncPageFetcher<ListInstanceFleetsResponse> {
        private ListInstanceFleetsResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceFleetsResponse previousPage) {
            return previousPage.marker() != null && !SdkAutoConstructList.class.isInstance(previousPage.marker()) && !SdkAutoConstructMap.class.isInstance(previousPage.marker());
        }

        public CompletableFuture<ListInstanceFleetsResponse> nextPage(ListInstanceFleetsResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceFleetsPublisher.this.client.listInstanceFleets(ListInstanceFleetsPublisher.this.firstRequest);
            }
            return ListInstanceFleetsPublisher.this.client.listInstanceFleets((ListInstanceFleetsRequest)((Object)ListInstanceFleetsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

