/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.transform.StepTimelineMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StepTimeline
implements StructuredPojo,
ToCopyableBuilder<Builder, StepTimeline> {
    private final Instant creationDateTime;
    private final Instant startDateTime;
    private final Instant endDateTime;

    private StepTimeline(BuilderImpl builder) {
        this.creationDateTime = builder.creationDateTime;
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
    }

    public Instant creationDateTime() {
        return this.creationDateTime;
    }

    public Instant startDateTime() {
        return this.startDateTime;
    }

    public Instant endDateTime() {
        return this.endDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepTimeline)) {
            return false;
        }
        StepTimeline other = (StepTimeline)obj;
        return Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.startDateTime(), other.startDateTime()) && Objects.equals(this.endDateTime(), other.endDateTime());
    }

    public String toString() {
        return ToString.builder((String)"StepTimeline").add("CreationDateTime", (Object)this.creationDateTime()).add("StartDateTime", (Object)this.startDateTime()).add("EndDateTime", (Object)this.endDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "StartDateTime": {
                return Optional.ofNullable(clazz.cast(this.startDateTime()));
            }
            case "EndDateTime": {
                return Optional.ofNullable(clazz.cast(this.endDateTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StepTimelineMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationDateTime;
        private Instant startDateTime;
        private Instant endDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StepTimeline model) {
            this.creationDateTime(model.creationDateTime);
            this.startDateTime(model.startDateTime);
            this.endDateTime(model.endDateTime);
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getStartDateTime() {
            return this.startDateTime;
        }

        @Override
        public final Builder startDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final void setStartDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
        }

        public final Instant getEndDateTime() {
            return this.endDateTime;
        }

        @Override
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        public StepTimeline build() {
            return new StepTimeline(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StepTimeline> {
        public Builder creationDateTime(Instant var1);

        public Builder startDateTime(Instant var1);

        public Builder endDateTime(Instant var1);
    }
}

