/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.HadoopJarStepConfig;

@SdkInternalApi
public class HadoopJarStepConfigMarshaller {
    private static final MarshallingInfo<List> PROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Properties").build();
    private static final MarshallingInfo<String> JAR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Jar").build();
    private static final MarshallingInfo<String> MAINCLASS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MainClass").build();
    private static final MarshallingInfo<List> ARGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Args").build();
    private static final HadoopJarStepConfigMarshaller instance = new HadoopJarStepConfigMarshaller();

    public static HadoopJarStepConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(HadoopJarStepConfig hadoopJarStepConfig, ProtocolMarshaller protocolMarshaller) {
        if (hadoopJarStepConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(hadoopJarStepConfig.properties(), PROPERTIES_BINDING);
            protocolMarshaller.marshall((Object)hadoopJarStepConfig.jar(), JAR_BINDING);
            protocolMarshaller.marshall((Object)hadoopJarStepConfig.mainClass(), MAINCLASS_BINDING);
            protocolMarshaller.marshall(hadoopJarStepConfig.args(), ARGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

