/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.emr.model.XmlStringListCopier;
import software.amazon.awssdk.services.emr.transform.SupportedProductConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SupportedProductConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, SupportedProductConfig> {
    private final String name;
    private final List<String> args;

    private SupportedProductConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.args = builder.args;
    }

    public String name() {
        return this.name;
    }

    public List<String> args() {
        return this.args;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.args() == null ? 0 : this.args().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportedProductConfig)) {
            return false;
        }
        SupportedProductConfig other = (SupportedProductConfig)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.args() == null ^ this.args() == null) {
            return false;
        }
        return other.args() == null || other.args().equals(this.args());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.args() != null) {
            sb.append("Args: ").append(this.args()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SupportedProductConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> args = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(SupportedProductConfig model) {
            this.setName(model.name);
            this.setArgs(model.args);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getArgs() {
            return this.args;
        }

        @Override
        public final Builder args(Collection<String> args) {
            this.args = XmlStringListCopier.copy(args);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder args(String ... args) {
            if (this.args == null) {
                this.args = new SdkInternalList(args.length);
            }
            for (String e : args) {
                this.args.add(e);
            }
            return this;
        }

        public final void setArgs(Collection<String> args) {
            this.args = XmlStringListCopier.copy(args);
        }

        @SafeVarargs
        public final void setArgs(String ... args) {
            if (this.args == null) {
                this.args = new SdkInternalList(args.length);
            }
            for (String e : args) {
                this.args.add(e);
            }
        }

        public SupportedProductConfig build() {
            return new SupportedProductConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SupportedProductConfig> {
        public Builder name(String var1);

        public Builder args(Collection<String> var1);

        public Builder args(String ... var1);
    }
}

