/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.StepConfig;
import software.amazon.awssdk.services.emr.model.StepExecutionStatusDetail;
import software.amazon.awssdk.services.emr.transform.StepDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StepDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, StepDetail> {
    private final StepConfig stepConfig;
    private final StepExecutionStatusDetail executionStatusDetail;

    private StepDetail(BuilderImpl builder) {
        this.stepConfig = builder.stepConfig;
        this.executionStatusDetail = builder.executionStatusDetail;
    }

    public StepConfig stepConfig() {
        return this.stepConfig;
    }

    public StepExecutionStatusDetail executionStatusDetail() {
        return this.executionStatusDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stepConfig() == null ? 0 : this.stepConfig().hashCode());
        hashCode = 31 * hashCode + (this.executionStatusDetail() == null ? 0 : this.executionStatusDetail().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepDetail)) {
            return false;
        }
        StepDetail other = (StepDetail)obj;
        if (other.stepConfig() == null ^ this.stepConfig() == null) {
            return false;
        }
        if (other.stepConfig() != null && !other.stepConfig().equals(this.stepConfig())) {
            return false;
        }
        if (other.executionStatusDetail() == null ^ this.executionStatusDetail() == null) {
            return false;
        }
        return other.executionStatusDetail() == null || other.executionStatusDetail().equals(this.executionStatusDetail());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stepConfig() != null) {
            sb.append("StepConfig: ").append(this.stepConfig()).append(",");
        }
        if (this.executionStatusDetail() != null) {
            sb.append("ExecutionStatusDetail: ").append(this.executionStatusDetail()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StepDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private StepConfig stepConfig;
        private StepExecutionStatusDetail executionStatusDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(StepDetail model) {
            this.setStepConfig(model.stepConfig);
            this.setExecutionStatusDetail(model.executionStatusDetail);
        }

        public final StepConfig getStepConfig() {
            return this.stepConfig;
        }

        @Override
        public final Builder stepConfig(StepConfig stepConfig) {
            this.stepConfig = stepConfig;
            return this;
        }

        public final void setStepConfig(StepConfig stepConfig) {
            this.stepConfig = stepConfig;
        }

        public final StepExecutionStatusDetail getExecutionStatusDetail() {
            return this.executionStatusDetail;
        }

        @Override
        public final Builder executionStatusDetail(StepExecutionStatusDetail executionStatusDetail) {
            this.executionStatusDetail = executionStatusDetail;
            return this;
        }

        public final void setExecutionStatusDetail(StepExecutionStatusDetail executionStatusDetail) {
            this.executionStatusDetail = executionStatusDetail;
        }

        public StepDetail build() {
            return new StepDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StepDetail> {
        public Builder stepConfig(StepConfig var1);

        public Builder executionStatusDetail(StepExecutionStatusDetail var1);
    }
}

