/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.SpotProvisioningTimeoutAction;
import software.amazon.awssdk.services.emr.transform.SpotProvisioningSpecificationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SpotProvisioningSpecification
implements StructuredPojo,
ToCopyableBuilder<Builder, SpotProvisioningSpecification> {
    private final Integer timeoutDurationMinutes;
    private final String timeoutAction;
    private final Integer blockDurationMinutes;

    private SpotProvisioningSpecification(BuilderImpl builder) {
        this.timeoutDurationMinutes = builder.timeoutDurationMinutes;
        this.timeoutAction = builder.timeoutAction;
        this.blockDurationMinutes = builder.blockDurationMinutes;
    }

    public Integer timeoutDurationMinutes() {
        return this.timeoutDurationMinutes;
    }

    public String timeoutAction() {
        return this.timeoutAction;
    }

    public Integer blockDurationMinutes() {
        return this.blockDurationMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.timeoutDurationMinutes() == null ? 0 : this.timeoutDurationMinutes().hashCode());
        hashCode = 31 * hashCode + (this.timeoutAction() == null ? 0 : this.timeoutAction().hashCode());
        hashCode = 31 * hashCode + (this.blockDurationMinutes() == null ? 0 : this.blockDurationMinutes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotProvisioningSpecification)) {
            return false;
        }
        SpotProvisioningSpecification other = (SpotProvisioningSpecification)obj;
        if (other.timeoutDurationMinutes() == null ^ this.timeoutDurationMinutes() == null) {
            return false;
        }
        if (other.timeoutDurationMinutes() != null && !other.timeoutDurationMinutes().equals(this.timeoutDurationMinutes())) {
            return false;
        }
        if (other.timeoutAction() == null ^ this.timeoutAction() == null) {
            return false;
        }
        if (other.timeoutAction() != null && !other.timeoutAction().equals(this.timeoutAction())) {
            return false;
        }
        if (other.blockDurationMinutes() == null ^ this.blockDurationMinutes() == null) {
            return false;
        }
        return other.blockDurationMinutes() == null || other.blockDurationMinutes().equals(this.blockDurationMinutes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.timeoutDurationMinutes() != null) {
            sb.append("TimeoutDurationMinutes: ").append(this.timeoutDurationMinutes()).append(",");
        }
        if (this.timeoutAction() != null) {
            sb.append("TimeoutAction: ").append(this.timeoutAction()).append(",");
        }
        if (this.blockDurationMinutes() != null) {
            sb.append("BlockDurationMinutes: ").append(this.blockDurationMinutes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SpotProvisioningSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer timeoutDurationMinutes;
        private String timeoutAction;
        private Integer blockDurationMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotProvisioningSpecification model) {
            this.setTimeoutDurationMinutes(model.timeoutDurationMinutes);
            this.setTimeoutAction(model.timeoutAction);
            this.setBlockDurationMinutes(model.blockDurationMinutes);
        }

        public final Integer getTimeoutDurationMinutes() {
            return this.timeoutDurationMinutes;
        }

        @Override
        public final Builder timeoutDurationMinutes(Integer timeoutDurationMinutes) {
            this.timeoutDurationMinutes = timeoutDurationMinutes;
            return this;
        }

        public final void setTimeoutDurationMinutes(Integer timeoutDurationMinutes) {
            this.timeoutDurationMinutes = timeoutDurationMinutes;
        }

        public final String getTimeoutAction() {
            return this.timeoutAction;
        }

        @Override
        public final Builder timeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
            return this;
        }

        @Override
        public final Builder timeoutAction(SpotProvisioningTimeoutAction timeoutAction) {
            this.timeoutAction(timeoutAction.toString());
            return this;
        }

        public final void setTimeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
        }

        public final void setTimeoutAction(SpotProvisioningTimeoutAction timeoutAction) {
            this.timeoutAction(timeoutAction.toString());
        }

        public final Integer getBlockDurationMinutes() {
            return this.blockDurationMinutes;
        }

        @Override
        public final Builder blockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
            return this;
        }

        public final void setBlockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
        }

        public SpotProvisioningSpecification build() {
            return new SpotProvisioningSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SpotProvisioningSpecification> {
        public Builder timeoutDurationMinutes(Integer var1);

        public Builder timeoutAction(String var1);

        public Builder timeoutAction(SpotProvisioningTimeoutAction var1);

        public Builder blockDurationMinutes(Integer var1);
    }
}

