/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.ScalingAction;
import software.amazon.awssdk.services.emr.model.ScalingTrigger;
import software.amazon.awssdk.services.emr.transform.ScalingRuleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScalingRule
implements StructuredPojo,
ToCopyableBuilder<Builder, ScalingRule> {
    private final String name;
    private final String description;
    private final ScalingAction action;
    private final ScalingTrigger trigger;

    private ScalingRule(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.action = builder.action;
        this.trigger = builder.trigger;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public ScalingAction action() {
        return this.action;
    }

    public ScalingTrigger trigger() {
        return this.trigger;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.action() == null ? 0 : this.action().hashCode());
        hashCode = 31 * hashCode + (this.trigger() == null ? 0 : this.trigger().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingRule)) {
            return false;
        }
        ScalingRule other = (ScalingRule)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        if (other.trigger() == null ^ this.trigger() == null) {
            return false;
        }
        return other.trigger() == null || other.trigger().equals(this.trigger());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.action() != null) {
            sb.append("Action: ").append(this.action()).append(",");
        }
        if (this.trigger() != null) {
            sb.append("Trigger: ").append(this.trigger()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScalingRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private ScalingAction action;
        private ScalingTrigger trigger;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingRule model) {
            this.setName(model.name);
            this.setDescription(model.description);
            this.setAction(model.action);
            this.setTrigger(model.trigger);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ScalingAction getAction() {
            return this.action;
        }

        @Override
        public final Builder action(ScalingAction action) {
            this.action = action;
            return this;
        }

        public final void setAction(ScalingAction action) {
            this.action = action;
        }

        public final ScalingTrigger getTrigger() {
            return this.trigger;
        }

        @Override
        public final Builder trigger(ScalingTrigger trigger) {
            this.trigger = trigger;
            return this;
        }

        public final void setTrigger(ScalingTrigger trigger) {
            this.trigger = trigger;
        }

        public ScalingRule build() {
            return new ScalingRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScalingRule> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder action(ScalingAction var1);

        public Builder trigger(ScalingTrigger var1);
    }
}

