/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.emr.model.StepState;
import software.amazon.awssdk.services.emr.model.StepStateListCopier;
import software.amazon.awssdk.services.emr.model.XmlStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListStepsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListStepsRequest> {
    private final String clusterId;
    private final List<String> stepStates;
    private final List<String> stepIds;
    private final String marker;

    private ListStepsRequest(BuilderImpl builder) {
        this.clusterId = builder.clusterId;
        this.stepStates = builder.stepStates;
        this.stepIds = builder.stepIds;
        this.marker = builder.marker;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public List<String> stepStates() {
        return this.stepStates;
    }

    public List<String> stepIds() {
        return this.stepIds;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterId() == null ? 0 : this.clusterId().hashCode());
        hashCode = 31 * hashCode + (this.stepStates() == null ? 0 : this.stepStates().hashCode());
        hashCode = 31 * hashCode + (this.stepIds() == null ? 0 : this.stepIds().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStepsRequest)) {
            return false;
        }
        ListStepsRequest other = (ListStepsRequest)((Object)obj);
        if (other.clusterId() == null ^ this.clusterId() == null) {
            return false;
        }
        if (other.clusterId() != null && !other.clusterId().equals(this.clusterId())) {
            return false;
        }
        if (other.stepStates() == null ^ this.stepStates() == null) {
            return false;
        }
        if (other.stepStates() != null && !other.stepStates().equals(this.stepStates())) {
            return false;
        }
        if (other.stepIds() == null ^ this.stepIds() == null) {
            return false;
        }
        if (other.stepIds() != null && !other.stepIds().equals(this.stepIds())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterId() != null) {
            sb.append("ClusterId: ").append(this.clusterId()).append(",");
        }
        if (this.stepStates() != null) {
            sb.append("StepStates: ").append(this.stepStates()).append(",");
        }
        if (this.stepIds() != null) {
            sb.append("StepIds: ").append(this.stepIds()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterId;
        private List<String> stepStates = new SdkInternalList();
        private List<String> stepIds = new SdkInternalList();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStepsRequest model) {
            this.setClusterId(model.clusterId);
            this.setStepStates(model.stepStates);
            this.setStepIds(model.stepIds);
            this.setMarker(model.marker);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final Collection<String> getStepStates() {
            return this.stepStates;
        }

        @Override
        public final Builder stepStates(Collection<String> stepStates) {
            this.stepStates = StepStateListCopier.copy(stepStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepStates(String ... stepStates) {
            if (this.stepStates == null) {
                this.stepStates = new SdkInternalList(stepStates.length);
            }
            for (String e : stepStates) {
                this.stepStates.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepStates(StepState ... stepStates) {
            if (this.stepStates == null) {
                this.stepStates = new SdkInternalList(stepStates.length);
            }
            for (StepState ele : stepStates) {
                this.stepStates.add(ele.toString());
            }
            return this;
        }

        public final void setStepStates(Collection<String> stepStates) {
            this.stepStates = StepStateListCopier.copy(stepStates);
        }

        @SafeVarargs
        public final void setStepStates(String ... stepStates) {
            if (this.stepStates == null) {
                this.stepStates = new SdkInternalList(stepStates.length);
            }
            for (String e : stepStates) {
                this.stepStates.add(e);
            }
        }

        @SafeVarargs
        public final void setStepStates(StepState ... stepStates) {
            if (this.stepStates == null) {
                this.stepStates = new SdkInternalList(stepStates.length);
            }
            for (StepState ele : stepStates) {
                this.stepStates.add(ele.toString());
            }
        }

        public final Collection<String> getStepIds() {
            return this.stepIds;
        }

        @Override
        public final Builder stepIds(Collection<String> stepIds) {
            this.stepIds = XmlStringListCopier.copy(stepIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepIds(String ... stepIds) {
            if (this.stepIds == null) {
                this.stepIds = new SdkInternalList(stepIds.length);
            }
            for (String e : stepIds) {
                this.stepIds.add(e);
            }
            return this;
        }

        public final void setStepIds(Collection<String> stepIds) {
            this.stepIds = XmlStringListCopier.copy(stepIds);
        }

        @SafeVarargs
        public final void setStepIds(String ... stepIds) {
            if (this.stepIds == null) {
                this.stepIds = new SdkInternalList(stepIds.length);
            }
            for (String e : stepIds) {
                this.stepIds.add(e);
            }
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListStepsRequest build() {
            return new ListStepsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListStepsRequest> {
        public Builder clusterId(String var1);

        public Builder stepStates(Collection<String> var1);

        public Builder stepStates(String ... var1);

        public Builder stepStates(StepState ... var1);

        public Builder stepIds(Collection<String> var1);

        public Builder stepIds(String ... var1);

        public Builder marker(String var1);
    }
}

