/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.emr.model.ClusterState;
import software.amazon.awssdk.services.emr.model.ClusterStateListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListClustersRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListClustersRequest> {
    private final Date createdAfter;
    private final Date createdBefore;
    private final List<String> clusterStates;
    private final String marker;

    private ListClustersRequest(BuilderImpl builder) {
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.clusterStates = builder.clusterStates;
        this.marker = builder.marker;
    }

    public Date createdAfter() {
        return this.createdAfter;
    }

    public Date createdBefore() {
        return this.createdBefore;
    }

    public List<String> clusterStates() {
        return this.clusterStates;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.createdAfter() == null ? 0 : this.createdAfter().hashCode());
        hashCode = 31 * hashCode + (this.createdBefore() == null ? 0 : this.createdBefore().hashCode());
        hashCode = 31 * hashCode + (this.clusterStates() == null ? 0 : this.clusterStates().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersRequest)) {
            return false;
        }
        ListClustersRequest other = (ListClustersRequest)((Object)obj);
        if (other.createdAfter() == null ^ this.createdAfter() == null) {
            return false;
        }
        if (other.createdAfter() != null && !other.createdAfter().equals(this.createdAfter())) {
            return false;
        }
        if (other.createdBefore() == null ^ this.createdBefore() == null) {
            return false;
        }
        if (other.createdBefore() != null && !other.createdBefore().equals(this.createdBefore())) {
            return false;
        }
        if (other.clusterStates() == null ^ this.clusterStates() == null) {
            return false;
        }
        if (other.clusterStates() != null && !other.clusterStates().equals(this.clusterStates())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.createdAfter() != null) {
            sb.append("CreatedAfter: ").append(this.createdAfter()).append(",");
        }
        if (this.createdBefore() != null) {
            sb.append("CreatedBefore: ").append(this.createdBefore()).append(",");
        }
        if (this.clusterStates() != null) {
            sb.append("ClusterStates: ").append(this.clusterStates()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Date createdAfter;
        private Date createdBefore;
        private List<String> clusterStates = new SdkInternalList();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersRequest model) {
            this.setCreatedAfter(model.createdAfter);
            this.setCreatedBefore(model.createdBefore);
            this.setClusterStates(model.clusterStates);
            this.setMarker(model.marker);
        }

        public final Date getCreatedAfter() {
            return this.createdAfter;
        }

        @Override
        public final Builder createdAfter(Date createdAfter) {
            this.createdAfter = StandardMemberCopier.copy((Date)createdAfter);
            return this;
        }

        public final void setCreatedAfter(Date createdAfter) {
            this.createdAfter = StandardMemberCopier.copy((Date)createdAfter);
        }

        public final Date getCreatedBefore() {
            return this.createdBefore;
        }

        @Override
        public final Builder createdBefore(Date createdBefore) {
            this.createdBefore = StandardMemberCopier.copy((Date)createdBefore);
            return this;
        }

        public final void setCreatedBefore(Date createdBefore) {
            this.createdBefore = StandardMemberCopier.copy((Date)createdBefore);
        }

        public final Collection<String> getClusterStates() {
            return this.clusterStates;
        }

        @Override
        public final Builder clusterStates(Collection<String> clusterStates) {
            this.clusterStates = ClusterStateListCopier.copy(clusterStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterStates(String ... clusterStates) {
            if (this.clusterStates == null) {
                this.clusterStates = new SdkInternalList(clusterStates.length);
            }
            for (String e : clusterStates) {
                this.clusterStates.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterStates(ClusterState ... clusterStates) {
            if (this.clusterStates == null) {
                this.clusterStates = new SdkInternalList(clusterStates.length);
            }
            for (ClusterState ele : clusterStates) {
                this.clusterStates.add(ele.toString());
            }
            return this;
        }

        public final void setClusterStates(Collection<String> clusterStates) {
            this.clusterStates = ClusterStateListCopier.copy(clusterStates);
        }

        @SafeVarargs
        public final void setClusterStates(String ... clusterStates) {
            if (this.clusterStates == null) {
                this.clusterStates = new SdkInternalList(clusterStates.length);
            }
            for (String e : clusterStates) {
                this.clusterStates.add(e);
            }
        }

        @SafeVarargs
        public final void setClusterStates(ClusterState ... clusterStates) {
            if (this.clusterStates == null) {
                this.clusterStates = new SdkInternalList(clusterStates.length);
            }
            for (ClusterState ele : clusterStates) {
                this.clusterStates.add(ele.toString());
            }
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListClustersRequest build() {
            return new ListClustersRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListClustersRequest> {
        public Builder createdAfter(Date var1);

        public Builder createdBefore(Date var1);

        public Builder clusterStates(Collection<String> var1);

        public Builder clusterStates(String ... var1);

        public Builder clusterStates(ClusterState ... var1);

        public Builder marker(String var1);
    }
}

