/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.emr.model.AutoScalingPolicy;
import software.amazon.awssdk.services.emr.model.Configuration;
import software.amazon.awssdk.services.emr.model.ConfigurationListCopier;
import software.amazon.awssdk.services.emr.model.EbsConfiguration;
import software.amazon.awssdk.services.emr.model.InstanceRoleType;
import software.amazon.awssdk.services.emr.model.MarketType;
import software.amazon.awssdk.services.emr.transform.InstanceGroupConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceGroupConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceGroupConfig> {
    private final String name;
    private final String market;
    private final String instanceRole;
    private final String bidPrice;
    private final String instanceType;
    private final Integer instanceCount;
    private final List<Configuration> configurations;
    private final EbsConfiguration ebsConfiguration;
    private final AutoScalingPolicy autoScalingPolicy;

    private InstanceGroupConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.market = builder.market;
        this.instanceRole = builder.instanceRole;
        this.bidPrice = builder.bidPrice;
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.configurations = builder.configurations;
        this.ebsConfiguration = builder.ebsConfiguration;
        this.autoScalingPolicy = builder.autoScalingPolicy;
    }

    public String name() {
        return this.name;
    }

    public String market() {
        return this.market;
    }

    public String instanceRole() {
        return this.instanceRole;
    }

    public String bidPrice() {
        return this.bidPrice;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public List<Configuration> configurations() {
        return this.configurations;
    }

    public EbsConfiguration ebsConfiguration() {
        return this.ebsConfiguration;
    }

    public AutoScalingPolicy autoScalingPolicy() {
        return this.autoScalingPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.market() == null ? 0 : this.market().hashCode());
        hashCode = 31 * hashCode + (this.instanceRole() == null ? 0 : this.instanceRole().hashCode());
        hashCode = 31 * hashCode + (this.bidPrice() == null ? 0 : this.bidPrice().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.instanceCount() == null ? 0 : this.instanceCount().hashCode());
        hashCode = 31 * hashCode + (this.configurations() == null ? 0 : this.configurations().hashCode());
        hashCode = 31 * hashCode + (this.ebsConfiguration() == null ? 0 : this.ebsConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.autoScalingPolicy() == null ? 0 : this.autoScalingPolicy().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceGroupConfig)) {
            return false;
        }
        InstanceGroupConfig other = (InstanceGroupConfig)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.market() == null ^ this.market() == null) {
            return false;
        }
        if (other.market() != null && !other.market().equals(this.market())) {
            return false;
        }
        if (other.instanceRole() == null ^ this.instanceRole() == null) {
            return false;
        }
        if (other.instanceRole() != null && !other.instanceRole().equals(this.instanceRole())) {
            return false;
        }
        if (other.bidPrice() == null ^ this.bidPrice() == null) {
            return false;
        }
        if (other.bidPrice() != null && !other.bidPrice().equals(this.bidPrice())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.instanceCount() == null ^ this.instanceCount() == null) {
            return false;
        }
        if (other.instanceCount() != null && !other.instanceCount().equals(this.instanceCount())) {
            return false;
        }
        if (other.configurations() == null ^ this.configurations() == null) {
            return false;
        }
        if (other.configurations() != null && !other.configurations().equals(this.configurations())) {
            return false;
        }
        if (other.ebsConfiguration() == null ^ this.ebsConfiguration() == null) {
            return false;
        }
        if (other.ebsConfiguration() != null && !other.ebsConfiguration().equals(this.ebsConfiguration())) {
            return false;
        }
        if (other.autoScalingPolicy() == null ^ this.autoScalingPolicy() == null) {
            return false;
        }
        return other.autoScalingPolicy() == null || other.autoScalingPolicy().equals(this.autoScalingPolicy());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.market() != null) {
            sb.append("Market: ").append(this.market()).append(",");
        }
        if (this.instanceRole() != null) {
            sb.append("InstanceRole: ").append(this.instanceRole()).append(",");
        }
        if (this.bidPrice() != null) {
            sb.append("BidPrice: ").append(this.bidPrice()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.instanceCount() != null) {
            sb.append("InstanceCount: ").append(this.instanceCount()).append(",");
        }
        if (this.configurations() != null) {
            sb.append("Configurations: ").append(this.configurations()).append(",");
        }
        if (this.ebsConfiguration() != null) {
            sb.append("EbsConfiguration: ").append(this.ebsConfiguration()).append(",");
        }
        if (this.autoScalingPolicy() != null) {
            sb.append("AutoScalingPolicy: ").append(this.autoScalingPolicy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceGroupConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String market;
        private String instanceRole;
        private String bidPrice;
        private String instanceType;
        private Integer instanceCount;
        private List<Configuration> configurations = new SdkInternalList();
        private EbsConfiguration ebsConfiguration;
        private AutoScalingPolicy autoScalingPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceGroupConfig model) {
            this.setName(model.name);
            this.setMarket(model.market);
            this.setInstanceRole(model.instanceRole);
            this.setBidPrice(model.bidPrice);
            this.setInstanceType(model.instanceType);
            this.setInstanceCount(model.instanceCount);
            this.setConfigurations(model.configurations);
            this.setEbsConfiguration(model.ebsConfiguration);
            this.setAutoScalingPolicy(model.autoScalingPolicy);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMarket() {
            return this.market;
        }

        @Override
        public final Builder market(String market) {
            this.market = market;
            return this;
        }

        @Override
        public final Builder market(MarketType market) {
            this.market(market.toString());
            return this;
        }

        public final void setMarket(String market) {
            this.market = market;
        }

        public final void setMarket(MarketType market) {
            this.market(market.toString());
        }

        public final String getInstanceRole() {
            return this.instanceRole;
        }

        @Override
        public final Builder instanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
            return this;
        }

        @Override
        public final Builder instanceRole(InstanceRoleType instanceRole) {
            this.instanceRole(instanceRole.toString());
            return this;
        }

        public final void setInstanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
        }

        public final void setInstanceRole(InstanceRoleType instanceRole) {
            this.instanceRole(instanceRole.toString());
        }

        public final String getBidPrice() {
            return this.bidPrice;
        }

        @Override
        public final Builder bidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
            return this;
        }

        public final void setBidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final Collection<Configuration> getConfigurations() {
            return this.configurations;
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration ... configurations) {
            if (this.configurations == null) {
                this.configurations = new SdkInternalList(configurations.length);
            }
            for (Configuration e : configurations) {
                this.configurations.add(e);
            }
            return this;
        }

        public final void setConfigurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
        }

        @SafeVarargs
        public final void setConfigurations(Configuration ... configurations) {
            if (this.configurations == null) {
                this.configurations = new SdkInternalList(configurations.length);
            }
            for (Configuration e : configurations) {
                this.configurations.add(e);
            }
        }

        public final EbsConfiguration getEbsConfiguration() {
            return this.ebsConfiguration;
        }

        @Override
        public final Builder ebsConfiguration(EbsConfiguration ebsConfiguration) {
            this.ebsConfiguration = ebsConfiguration;
            return this;
        }

        public final void setEbsConfiguration(EbsConfiguration ebsConfiguration) {
            this.ebsConfiguration = ebsConfiguration;
        }

        public final AutoScalingPolicy getAutoScalingPolicy() {
            return this.autoScalingPolicy;
        }

        @Override
        public final Builder autoScalingPolicy(AutoScalingPolicy autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy;
            return this;
        }

        public final void setAutoScalingPolicy(AutoScalingPolicy autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy;
        }

        public InstanceGroupConfig build() {
            return new InstanceGroupConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceGroupConfig> {
        public Builder name(String var1);

        public Builder market(String var1);

        public Builder market(MarketType var1);

        public Builder instanceRole(String var1);

        public Builder instanceRole(InstanceRoleType var1);

        public Builder bidPrice(String var1);

        public Builder instanceType(String var1);

        public Builder instanceCount(Integer var1);

        public Builder configurations(Collection<Configuration> var1);

        public Builder configurations(Configuration ... var1);

        public Builder ebsConfiguration(EbsConfiguration var1);

        public Builder autoScalingPolicy(AutoScalingPolicy var1);
    }
}

