/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elastictranscoder.model.HlsContentProtection;
import software.amazon.awssdk.services.elastictranscoder.model.OutputKeysCopier;
import software.amazon.awssdk.services.elastictranscoder.model.PlayReadyDrm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Playlist
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Playlist> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Playlist.getter(Playlist::name)).setter(Playlist.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(Playlist.getter(Playlist::format)).setter(Playlist.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<List<String>> OUTPUT_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutputKeys").getter(Playlist.getter(Playlist::outputKeys)).setter(Playlist.setter(Builder::outputKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<HlsContentProtection> HLS_CONTENT_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HlsContentProtection").getter(Playlist.getter(Playlist::hlsContentProtection)).setter(Playlist.setter(Builder::hlsContentProtection)).constructor(HlsContentProtection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HlsContentProtection").build()}).build();
    private static final SdkField<PlayReadyDrm> PLAY_READY_DRM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PlayReadyDrm").getter(Playlist.getter(Playlist::playReadyDrm)).setter(Playlist.setter(Builder::playReadyDrm)).constructor(PlayReadyDrm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayReadyDrm").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Playlist.getter(Playlist::status)).setter(Playlist.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusDetail").getter(Playlist.getter(Playlist::statusDetail)).setter(Playlist.setter(Builder::statusDetail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FORMAT_FIELD, OUTPUT_KEYS_FIELD, HLS_CONTENT_PROTECTION_FIELD, PLAY_READY_DRM_FIELD, STATUS_FIELD, STATUS_DETAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Playlist.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String format;
    private final List<String> outputKeys;
    private final HlsContentProtection hlsContentProtection;
    private final PlayReadyDrm playReadyDrm;
    private final String status;
    private final String statusDetail;

    private Playlist(BuilderImpl builder) {
        this.name = builder.name;
        this.format = builder.format;
        this.outputKeys = builder.outputKeys;
        this.hlsContentProtection = builder.hlsContentProtection;
        this.playReadyDrm = builder.playReadyDrm;
        this.status = builder.status;
        this.statusDetail = builder.statusDetail;
    }

    public final String name() {
        return this.name;
    }

    public final String format() {
        return this.format;
    }

    public final boolean hasOutputKeys() {
        return this.outputKeys != null && !(this.outputKeys instanceof SdkAutoConstructList);
    }

    public final List<String> outputKeys() {
        return this.outputKeys;
    }

    public final HlsContentProtection hlsContentProtection() {
        return this.hlsContentProtection;
    }

    public final PlayReadyDrm playReadyDrm() {
        return this.playReadyDrm;
    }

    public final String status() {
        return this.status;
    }

    public final String statusDetail() {
        return this.statusDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputKeys() ? this.outputKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsContentProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.playReadyDrm());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Playlist)) {
            return false;
        }
        Playlist other = (Playlist)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.format(), other.format()) && this.hasOutputKeys() == other.hasOutputKeys() && Objects.equals(this.outputKeys(), other.outputKeys()) && Objects.equals(this.hlsContentProtection(), other.hlsContentProtection()) && Objects.equals(this.playReadyDrm(), other.playReadyDrm()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statusDetail(), other.statusDetail());
    }

    public final String toString() {
        return ToString.builder((String)"Playlist").add("Name", (Object)this.name()).add("Format", (Object)this.format()).add("OutputKeys", this.hasOutputKeys() ? this.outputKeys() : null).add("HlsContentProtection", (Object)this.hlsContentProtection()).add("PlayReadyDrm", (Object)this.playReadyDrm()).add("Status", (Object)this.status()).add("StatusDetail", (Object)this.statusDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
            case "OutputKeys": {
                return Optional.ofNullable(clazz.cast(this.outputKeys()));
            }
            case "HlsContentProtection": {
                return Optional.ofNullable(clazz.cast(this.hlsContentProtection()));
            }
            case "PlayReadyDrm": {
                return Optional.ofNullable(clazz.cast(this.playReadyDrm()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StatusDetail": {
                return Optional.ofNullable(clazz.cast(this.statusDetail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Format", FORMAT_FIELD);
        map.put("OutputKeys", OUTPUT_KEYS_FIELD);
        map.put("HlsContentProtection", HLS_CONTENT_PROTECTION_FIELD);
        map.put("PlayReadyDrm", PLAY_READY_DRM_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusDetail", STATUS_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Playlist, T> g) {
        return obj -> g.apply((Playlist)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String format;
        private List<String> outputKeys = DefaultSdkAutoConstructList.getInstance();
        private HlsContentProtection hlsContentProtection;
        private PlayReadyDrm playReadyDrm;
        private String status;
        private String statusDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(Playlist model) {
            this.name(model.name);
            this.format(model.format);
            this.outputKeys(model.outputKeys);
            this.hlsContentProtection(model.hlsContentProtection);
            this.playReadyDrm(model.playReadyDrm);
            this.status(model.status);
            this.statusDetail(model.statusDetail);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final Collection<String> getOutputKeys() {
            if (this.outputKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.outputKeys;
        }

        public final void setOutputKeys(Collection<String> outputKeys) {
            this.outputKeys = OutputKeysCopier.copy(outputKeys);
        }

        @Override
        public final Builder outputKeys(Collection<String> outputKeys) {
            this.outputKeys = OutputKeysCopier.copy(outputKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputKeys(String ... outputKeys) {
            this.outputKeys(Arrays.asList(outputKeys));
            return this;
        }

        public final HlsContentProtection.Builder getHlsContentProtection() {
            return this.hlsContentProtection != null ? this.hlsContentProtection.toBuilder() : null;
        }

        public final void setHlsContentProtection(HlsContentProtection.BuilderImpl hlsContentProtection) {
            this.hlsContentProtection = hlsContentProtection != null ? hlsContentProtection.build() : null;
        }

        @Override
        public final Builder hlsContentProtection(HlsContentProtection hlsContentProtection) {
            this.hlsContentProtection = hlsContentProtection;
            return this;
        }

        public final PlayReadyDrm.Builder getPlayReadyDrm() {
            return this.playReadyDrm != null ? this.playReadyDrm.toBuilder() : null;
        }

        public final void setPlayReadyDrm(PlayReadyDrm.BuilderImpl playReadyDrm) {
            this.playReadyDrm = playReadyDrm != null ? playReadyDrm.build() : null;
        }

        @Override
        public final Builder playReadyDrm(PlayReadyDrm playReadyDrm) {
            this.playReadyDrm = playReadyDrm;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStatusDetail() {
            return this.statusDetail;
        }

        public final void setStatusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
        }

        @Override
        public final Builder statusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
            return this;
        }

        public Playlist build() {
            return new Playlist(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Playlist> {
        public Builder name(String var1);

        public Builder format(String var1);

        public Builder outputKeys(Collection<String> var1);

        public Builder outputKeys(String ... var1);

        public Builder hlsContentProtection(HlsContentProtection var1);

        default public Builder hlsContentProtection(Consumer<HlsContentProtection.Builder> hlsContentProtection) {
            return this.hlsContentProtection((HlsContentProtection)((HlsContentProtection.Builder)HlsContentProtection.builder().applyMutation(hlsContentProtection)).build());
        }

        public Builder playReadyDrm(PlayReadyDrm var1);

        default public Builder playReadyDrm(Consumer<PlayReadyDrm.Builder> playReadyDrm) {
            return this.playReadyDrm((PlayReadyDrm)((PlayReadyDrm.Builder)PlayReadyDrm.builder().applyMutation(playReadyDrm)).build());
        }

        public Builder status(String var1);

        public Builder statusDetail(String var1);
    }
}

