/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum UpgradeStep {
    PRE_UPGRADE_CHECK("PRE_UPGRADE_CHECK"),
    SNAPSHOT("SNAPSHOT"),
    UPGRADE("UPGRADE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private UpgradeStep(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UpgradeStep fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(UpgradeStep.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UpgradeStep> knownValues() {
        return Stream.of(UpgradeStep.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

