/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.elasticsearch.model.LogPublishingOption;
import software.amazon.awssdk.services.elasticsearch.model.LogPublishingOptionsCopier;
import software.amazon.awssdk.services.elasticsearch.model.LogType;
import software.amazon.awssdk.services.elasticsearch.model.OptionStatus;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogPublishingOptionsStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogPublishingOptionsStatus> {
    private static final SdkField<Map<String, LogPublishingOption>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(LogPublishingOptionsStatus.getter(LogPublishingOptionsStatus::optionsAsStrings)).setter(LogPublishingOptionsStatus.setter(Builder::optionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogPublishingOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<OptionStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(LogPublishingOptionsStatus.getter(LogPublishingOptionsStatus::status)).setter(LogPublishingOptionsStatus.setter(Builder::status)).constructor(OptionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIONS_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, LogPublishingOption> options;
    private final OptionStatus status;

    private LogPublishingOptionsStatus(BuilderImpl builder) {
        this.options = builder.options;
        this.status = builder.status;
    }

    public Map<LogType, LogPublishingOption> options() {
        return LogPublishingOptionsCopier.copyStringToEnum(this.options);
    }

    public Map<String, LogPublishingOption> optionsAsStrings() {
        return this.options;
    }

    public OptionStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.optionsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogPublishingOptionsStatus)) {
            return false;
        }
        LogPublishingOptionsStatus other = (LogPublishingOptionsStatus)obj;
        return Objects.equals(this.optionsAsStrings(), other.optionsAsStrings()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"LogPublishingOptionsStatus").add("Options", this.optionsAsStrings()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.optionsAsStrings()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogPublishingOptionsStatus, T> g) {
        return obj -> g.apply((LogPublishingOptionsStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, LogPublishingOption> options = DefaultSdkAutoConstructMap.getInstance();
        private OptionStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(LogPublishingOptionsStatus model) {
            this.optionsWithStrings(model.options);
            this.status(model.status);
        }

        public final Map<String, LogPublishingOption.Builder> getOptionsAsStrings() {
            return this.options != null ? CollectionUtils.mapValues(this.options, LogPublishingOption::toBuilder) : null;
        }

        @Override
        public final Builder optionsWithStrings(Map<String, LogPublishingOption> options) {
            this.options = LogPublishingOptionsCopier.copy(options);
            return this;
        }

        @Override
        public final Builder options(Map<LogType, LogPublishingOption> options) {
            this.options = LogPublishingOptionsCopier.copyEnumToString(options);
            return this;
        }

        public final void setOptionsWithStrings(Map<String, LogPublishingOption.BuilderImpl> options) {
            this.options = LogPublishingOptionsCopier.copyFromBuilder(options);
        }

        public final OptionStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(OptionStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(OptionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public LogPublishingOptionsStatus build() {
            return new LogPublishingOptionsStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogPublishingOptionsStatus> {
        public Builder optionsWithStrings(Map<String, LogPublishingOption> var1);

        public Builder options(Map<LogType, LogPublishingOption> var1);

        public Builder status(OptionStatus var1);

        default public Builder status(Consumer<OptionStatus.Builder> status) {
            return this.status((OptionStatus)((OptionStatus.Builder)OptionStatus.builder().applyMutation(status)).build());
        }
    }
}

