/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstanceOffering;
import software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstanceOfferingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedElasticsearchInstanceOfferingsResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, DescribeReservedElasticsearchInstanceOfferingsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeReservedElasticsearchInstanceOfferingsResponse.getter(DescribeReservedElasticsearchInstanceOfferingsResponse::nextToken)).setter(DescribeReservedElasticsearchInstanceOfferingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ReservedElasticsearchInstanceOffering>> RESERVED_ELASTICSEARCH_INSTANCE_OFFERINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReservedElasticsearchInstanceOfferings").getter(DescribeReservedElasticsearchInstanceOfferingsResponse.getter(DescribeReservedElasticsearchInstanceOfferingsResponse::reservedElasticsearchInstanceOfferings)).setter(DescribeReservedElasticsearchInstanceOfferingsResponse.setter(Builder::reservedElasticsearchInstanceOfferings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedElasticsearchInstanceOfferings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedElasticsearchInstanceOffering::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESERVED_ELASTICSEARCH_INSTANCE_OFFERINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeReservedElasticsearchInstanceOfferingsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ReservedElasticsearchInstanceOffering> reservedElasticsearchInstanceOfferings;

    private DescribeReservedElasticsearchInstanceOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservedElasticsearchInstanceOfferings = builder.reservedElasticsearchInstanceOfferings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasReservedElasticsearchInstanceOfferings() {
        return this.reservedElasticsearchInstanceOfferings != null && !(this.reservedElasticsearchInstanceOfferings instanceof SdkAutoConstructList);
    }

    public final List<ReservedElasticsearchInstanceOffering> reservedElasticsearchInstanceOfferings() {
        return this.reservedElasticsearchInstanceOfferings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservedElasticsearchInstanceOfferings() ? this.reservedElasticsearchInstanceOfferings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedElasticsearchInstanceOfferingsResponse)) {
            return false;
        }
        DescribeReservedElasticsearchInstanceOfferingsResponse other = (DescribeReservedElasticsearchInstanceOfferingsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasReservedElasticsearchInstanceOfferings() == other.hasReservedElasticsearchInstanceOfferings() && Objects.equals(this.reservedElasticsearchInstanceOfferings(), other.reservedElasticsearchInstanceOfferings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReservedElasticsearchInstanceOfferingsResponse").add("NextToken", (Object)this.nextToken()).add("ReservedElasticsearchInstanceOfferings", this.hasReservedElasticsearchInstanceOfferings() ? this.reservedElasticsearchInstanceOfferings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ReservedElasticsearchInstanceOfferings": {
                return Optional.ofNullable(clazz.cast(this.reservedElasticsearchInstanceOfferings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ReservedElasticsearchInstanceOfferings", RESERVED_ELASTICSEARCH_INSTANCE_OFFERINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedElasticsearchInstanceOfferingsResponse, T> g) {
        return obj -> g.apply((DescribeReservedElasticsearchInstanceOfferingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ReservedElasticsearchInstanceOffering> reservedElasticsearchInstanceOfferings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedElasticsearchInstanceOfferingsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.reservedElasticsearchInstanceOfferings(model.reservedElasticsearchInstanceOfferings);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ReservedElasticsearchInstanceOffering.Builder> getReservedElasticsearchInstanceOfferings() {
            List<ReservedElasticsearchInstanceOffering.Builder> result = ReservedElasticsearchInstanceOfferingListCopier.copyToBuilder(this.reservedElasticsearchInstanceOfferings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedElasticsearchInstanceOfferings(Collection<ReservedElasticsearchInstanceOffering.BuilderImpl> reservedElasticsearchInstanceOfferings) {
            this.reservedElasticsearchInstanceOfferings = ReservedElasticsearchInstanceOfferingListCopier.copyFromBuilder(reservedElasticsearchInstanceOfferings);
        }

        @Override
        public final Builder reservedElasticsearchInstanceOfferings(Collection<ReservedElasticsearchInstanceOffering> reservedElasticsearchInstanceOfferings) {
            this.reservedElasticsearchInstanceOfferings = ReservedElasticsearchInstanceOfferingListCopier.copy(reservedElasticsearchInstanceOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedElasticsearchInstanceOfferings(ReservedElasticsearchInstanceOffering ... reservedElasticsearchInstanceOfferings) {
            this.reservedElasticsearchInstanceOfferings(Arrays.asList(reservedElasticsearchInstanceOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedElasticsearchInstanceOfferings(Consumer<ReservedElasticsearchInstanceOffering.Builder> ... reservedElasticsearchInstanceOfferings) {
            this.reservedElasticsearchInstanceOfferings(Stream.of(reservedElasticsearchInstanceOfferings).map(c -> (ReservedElasticsearchInstanceOffering)((ReservedElasticsearchInstanceOffering.Builder)ReservedElasticsearchInstanceOffering.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReservedElasticsearchInstanceOfferingsResponse build() {
            return new DescribeReservedElasticsearchInstanceOfferingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElasticsearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedElasticsearchInstanceOfferingsResponse> {
        public Builder nextToken(String var1);

        public Builder reservedElasticsearchInstanceOfferings(Collection<ReservedElasticsearchInstanceOffering> var1);

        public Builder reservedElasticsearchInstanceOfferings(ReservedElasticsearchInstanceOffering ... var1);

        public Builder reservedElasticsearchInstanceOfferings(Consumer<ReservedElasticsearchInstanceOffering.Builder> ... var1);
    }
}

