/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.services.elasticsearch.model.VpcEndpoint;
import software.amazon.awssdk.services.elasticsearch.model.VpcEndpointError;
import software.amazon.awssdk.services.elasticsearch.model.VpcEndpointErrorListCopier;
import software.amazon.awssdk.services.elasticsearch.model.VpcEndpointsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcEndpointsResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, DescribeVpcEndpointsResponse> {
    private static final SdkField<List<VpcEndpoint>> VPC_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcEndpoints").getter(DescribeVpcEndpointsResponse.getter(DescribeVpcEndpointsResponse::vpcEndpoints)).setter(DescribeVpcEndpointsResponse.setter(Builder::vpcEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<VpcEndpointError>> VPC_ENDPOINT_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcEndpointErrors").getter(DescribeVpcEndpointsResponse.getter(DescribeVpcEndpointsResponse::vpcEndpointErrors)).setter(DescribeVpcEndpointsResponse.setter(Builder::vpcEndpointErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcEndpointError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINTS_FIELD, VPC_ENDPOINT_ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeVpcEndpointsResponse.memberNameToFieldInitializer();
    private final List<VpcEndpoint> vpcEndpoints;
    private final List<VpcEndpointError> vpcEndpointErrors;

    private DescribeVpcEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcEndpoints = builder.vpcEndpoints;
        this.vpcEndpointErrors = builder.vpcEndpointErrors;
    }

    public final boolean hasVpcEndpoints() {
        return this.vpcEndpoints != null && !(this.vpcEndpoints instanceof SdkAutoConstructList);
    }

    public final List<VpcEndpoint> vpcEndpoints() {
        return this.vpcEndpoints;
    }

    public final boolean hasVpcEndpointErrors() {
        return this.vpcEndpointErrors != null && !(this.vpcEndpointErrors instanceof SdkAutoConstructList);
    }

    public final List<VpcEndpointError> vpcEndpointErrors() {
        return this.vpcEndpointErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcEndpoints() ? this.vpcEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcEndpointErrors() ? this.vpcEndpointErrors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointsResponse)) {
            return false;
        }
        DescribeVpcEndpointsResponse other = (DescribeVpcEndpointsResponse)((Object)obj);
        return this.hasVpcEndpoints() == other.hasVpcEndpoints() && Objects.equals(this.vpcEndpoints(), other.vpcEndpoints()) && this.hasVpcEndpointErrors() == other.hasVpcEndpointErrors() && Objects.equals(this.vpcEndpointErrors(), other.vpcEndpointErrors());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVpcEndpointsResponse").add("VpcEndpoints", this.hasVpcEndpoints() ? this.vpcEndpoints() : null).add("VpcEndpointErrors", this.hasVpcEndpointErrors() ? this.vpcEndpointErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcEndpoints": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpoints()));
            }
            case "VpcEndpointErrors": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointErrors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VpcEndpoints", VPC_ENDPOINTS_FIELD);
        map.put("VpcEndpointErrors", VPC_ENDPOINT_ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcEndpointsResponse, T> g) {
        return obj -> g.apply((DescribeVpcEndpointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private List<VpcEndpoint> vpcEndpoints = DefaultSdkAutoConstructList.getInstance();
        private List<VpcEndpointError> vpcEndpointErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointsResponse model) {
            super(model);
            this.vpcEndpoints(model.vpcEndpoints);
            this.vpcEndpointErrors(model.vpcEndpointErrors);
        }

        public final List<VpcEndpoint.Builder> getVpcEndpoints() {
            List<VpcEndpoint.Builder> result = VpcEndpointsCopier.copyToBuilder(this.vpcEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcEndpoints(Collection<VpcEndpoint.BuilderImpl> vpcEndpoints) {
            this.vpcEndpoints = VpcEndpointsCopier.copyFromBuilder(vpcEndpoints);
        }

        @Override
        public final Builder vpcEndpoints(Collection<VpcEndpoint> vpcEndpoints) {
            this.vpcEndpoints = VpcEndpointsCopier.copy(vpcEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpoints(VpcEndpoint ... vpcEndpoints) {
            this.vpcEndpoints(Arrays.asList(vpcEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpoints(Consumer<VpcEndpoint.Builder> ... vpcEndpoints) {
            this.vpcEndpoints(Stream.of(vpcEndpoints).map(c -> (VpcEndpoint)((VpcEndpoint.Builder)VpcEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VpcEndpointError.Builder> getVpcEndpointErrors() {
            List<VpcEndpointError.Builder> result = VpcEndpointErrorListCopier.copyToBuilder(this.vpcEndpointErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcEndpointErrors(Collection<VpcEndpointError.BuilderImpl> vpcEndpointErrors) {
            this.vpcEndpointErrors = VpcEndpointErrorListCopier.copyFromBuilder(vpcEndpointErrors);
        }

        @Override
        public final Builder vpcEndpointErrors(Collection<VpcEndpointError> vpcEndpointErrors) {
            this.vpcEndpointErrors = VpcEndpointErrorListCopier.copy(vpcEndpointErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointErrors(VpcEndpointError ... vpcEndpointErrors) {
            this.vpcEndpointErrors(Arrays.asList(vpcEndpointErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointErrors(Consumer<VpcEndpointError.Builder> ... vpcEndpointErrors) {
            this.vpcEndpointErrors(Stream.of(vpcEndpointErrors).map(c -> (VpcEndpointError)((VpcEndpointError.Builder)VpcEndpointError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeVpcEndpointsResponse build() {
            return new DescribeVpcEndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElasticsearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVpcEndpointsResponse> {
        public Builder vpcEndpoints(Collection<VpcEndpoint> var1);

        public Builder vpcEndpoints(VpcEndpoint ... var1);

        public Builder vpcEndpoints(Consumer<VpcEndpoint.Builder> ... var1);

        public Builder vpcEndpointErrors(Collection<VpcEndpointError> var1);

        public Builder vpcEndpointErrors(VpcEndpointError ... var1);

        public Builder vpcEndpointErrors(Consumer<VpcEndpointError.Builder> ... var1);
    }
}

