/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.ErrorDetails;
import software.amazon.awssdk.services.elasticsearch.model.PackageStatus;
import software.amazon.awssdk.services.elasticsearch.model.PackageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageDetails> {
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageID").getter(PackageDetails.getter(PackageDetails::packageID)).setter(PackageDetails.setter(Builder::packageID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageID").build()}).build();
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageName").getter(PackageDetails.getter(PackageDetails::packageName)).setter(PackageDetails.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()}).build();
    private static final SdkField<String> PACKAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageType").getter(PackageDetails.getter(PackageDetails::packageTypeAsString)).setter(PackageDetails.setter(Builder::packageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageType").build()}).build();
    private static final SdkField<String> PACKAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageDescription").getter(PackageDetails.getter(PackageDetails::packageDescription)).setter(PackageDetails.setter(Builder::packageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageDescription").build()}).build();
    private static final SdkField<String> PACKAGE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageStatus").getter(PackageDetails.getter(PackageDetails::packageStatusAsString)).setter(PackageDetails.setter(Builder::packageStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageStatus").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(PackageDetails.getter(PackageDetails::createdAt)).setter(PackageDetails.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(PackageDetails.getter(PackageDetails::lastUpdatedAt)).setter(PackageDetails.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<String> AVAILABLE_PACKAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailablePackageVersion").getter(PackageDetails.getter(PackageDetails::availablePackageVersion)).setter(PackageDetails.setter(Builder::availablePackageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailablePackageVersion").build()}).build();
    private static final SdkField<ErrorDetails> ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ErrorDetails").getter(PackageDetails.getter(PackageDetails::errorDetails)).setter(PackageDetails.setter(Builder::errorDetails)).constructor(ErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_ID_FIELD, PACKAGE_NAME_FIELD, PACKAGE_TYPE_FIELD, PACKAGE_DESCRIPTION_FIELD, PACKAGE_STATUS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, AVAILABLE_PACKAGE_VERSION_FIELD, ERROR_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PackageDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String packageID;
    private final String packageName;
    private final String packageType;
    private final String packageDescription;
    private final String packageStatus;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String availablePackageVersion;
    private final ErrorDetails errorDetails;

    private PackageDetails(BuilderImpl builder) {
        this.packageID = builder.packageID;
        this.packageName = builder.packageName;
        this.packageType = builder.packageType;
        this.packageDescription = builder.packageDescription;
        this.packageStatus = builder.packageStatus;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.availablePackageVersion = builder.availablePackageVersion;
        this.errorDetails = builder.errorDetails;
    }

    public final String packageID() {
        return this.packageID;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final PackageType packageType() {
        return PackageType.fromValue(this.packageType);
    }

    public final String packageTypeAsString() {
        return this.packageType;
    }

    public final String packageDescription() {
        return this.packageDescription;
    }

    public final PackageStatus packageStatus() {
        return PackageStatus.fromValue(this.packageStatus);
    }

    public final String packageStatusAsString() {
        return this.packageStatus;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String availablePackageVersion() {
        return this.availablePackageVersion;
    }

    public final ErrorDetails errorDetails() {
        return this.errorDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.packageID());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.availablePackageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageDetails)) {
            return false;
        }
        PackageDetails other = (PackageDetails)obj;
        return Objects.equals(this.packageID(), other.packageID()) && Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.packageTypeAsString(), other.packageTypeAsString()) && Objects.equals(this.packageDescription(), other.packageDescription()) && Objects.equals(this.packageStatusAsString(), other.packageStatusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.availablePackageVersion(), other.availablePackageVersion()) && Objects.equals(this.errorDetails(), other.errorDetails());
    }

    public final String toString() {
        return ToString.builder((String)"PackageDetails").add("PackageID", (Object)this.packageID()).add("PackageName", (Object)this.packageName()).add("PackageType", (Object)this.packageTypeAsString()).add("PackageDescription", (Object)this.packageDescription()).add("PackageStatus", (Object)this.packageStatusAsString()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("AvailablePackageVersion", (Object)this.availablePackageVersion()).add("ErrorDetails", (Object)this.errorDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PackageID": {
                return Optional.ofNullable(clazz.cast(this.packageID()));
            }
            case "PackageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "PackageType": {
                return Optional.ofNullable(clazz.cast(this.packageTypeAsString()));
            }
            case "PackageDescription": {
                return Optional.ofNullable(clazz.cast(this.packageDescription()));
            }
            case "PackageStatus": {
                return Optional.ofNullable(clazz.cast(this.packageStatusAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "AvailablePackageVersion": {
                return Optional.ofNullable(clazz.cast(this.availablePackageVersion()));
            }
            case "ErrorDetails": {
                return Optional.ofNullable(clazz.cast(this.errorDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PackageID", PACKAGE_ID_FIELD);
        map.put("PackageName", PACKAGE_NAME_FIELD);
        map.put("PackageType", PACKAGE_TYPE_FIELD);
        map.put("PackageDescription", PACKAGE_DESCRIPTION_FIELD);
        map.put("PackageStatus", PACKAGE_STATUS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("AvailablePackageVersion", AVAILABLE_PACKAGE_VERSION_FIELD);
        map.put("ErrorDetails", ERROR_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PackageDetails, T> g) {
        return obj -> g.apply((PackageDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String packageID;
        private String packageName;
        private String packageType;
        private String packageDescription;
        private String packageStatus;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String availablePackageVersion;
        private ErrorDetails errorDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageDetails model) {
            this.packageID(model.packageID);
            this.packageName(model.packageName);
            this.packageType(model.packageType);
            this.packageDescription(model.packageDescription);
            this.packageStatus(model.packageStatus);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.availablePackageVersion(model.availablePackageVersion);
            this.errorDetails(model.errorDetails);
        }

        public final String getPackageID() {
            return this.packageID;
        }

        public final void setPackageID(String packageID) {
            this.packageID = packageID;
        }

        @Override
        public final Builder packageID(String packageID) {
            this.packageID = packageID;
            return this;
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageType() {
            return this.packageType;
        }

        public final void setPackageType(String packageType) {
            this.packageType = packageType;
        }

        @Override
        public final Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        @Override
        public final Builder packageType(PackageType packageType) {
            this.packageType(packageType == null ? null : packageType.toString());
            return this;
        }

        public final String getPackageDescription() {
            return this.packageDescription;
        }

        public final void setPackageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
        }

        @Override
        public final Builder packageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
            return this;
        }

        public final String getPackageStatus() {
            return this.packageStatus;
        }

        public final void setPackageStatus(String packageStatus) {
            this.packageStatus = packageStatus;
        }

        @Override
        public final Builder packageStatus(String packageStatus) {
            this.packageStatus = packageStatus;
            return this;
        }

        @Override
        public final Builder packageStatus(PackageStatus packageStatus) {
            this.packageStatus(packageStatus == null ? null : packageStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getAvailablePackageVersion() {
            return this.availablePackageVersion;
        }

        public final void setAvailablePackageVersion(String availablePackageVersion) {
            this.availablePackageVersion = availablePackageVersion;
        }

        @Override
        public final Builder availablePackageVersion(String availablePackageVersion) {
            this.availablePackageVersion = availablePackageVersion;
            return this;
        }

        public final ErrorDetails.Builder getErrorDetails() {
            return this.errorDetails != null ? this.errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(ErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public PackageDetails build() {
            return new PackageDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageDetails> {
        public Builder packageID(String var1);

        public Builder packageName(String var1);

        public Builder packageType(String var1);

        public Builder packageType(PackageType var1);

        public Builder packageDescription(String var1);

        public Builder packageStatus(String var1);

        public Builder packageStatus(PackageStatus var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder availablePackageVersion(String var1);

        public Builder errorDetails(ErrorDetails var1);

        default public Builder errorDetails(Consumer<ErrorDetails.Builder> errorDetails) {
            return this.errorDetails((ErrorDetails)((ErrorDetails.Builder)ErrorDetails.builder().applyMutation(errorDetails)).build());
        }
    }
}

