/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchAsyncClient;
import software.amazon.awssdk.services.elasticsearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse;

public class DescribeOutboundCrossClusterSearchConnectionsPublisher
implements SdkPublisher<DescribeOutboundCrossClusterSearchConnectionsResponse> {
    private final ElasticsearchAsyncClient client;
    private final DescribeOutboundCrossClusterSearchConnectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeOutboundCrossClusterSearchConnectionsPublisher(ElasticsearchAsyncClient client, DescribeOutboundCrossClusterSearchConnectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeOutboundCrossClusterSearchConnectionsPublisher(ElasticsearchAsyncClient client, DescribeOutboundCrossClusterSearchConnectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeOutboundCrossClusterSearchConnectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeOutboundCrossClusterSearchConnectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeOutboundCrossClusterSearchConnectionsResponseFetcher
    implements AsyncPageFetcher<DescribeOutboundCrossClusterSearchConnectionsResponse> {
        private DescribeOutboundCrossClusterSearchConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOutboundCrossClusterSearchConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeOutboundCrossClusterSearchConnectionsResponse> nextPage(DescribeOutboundCrossClusterSearchConnectionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOutboundCrossClusterSearchConnectionsPublisher.this.client.describeOutboundCrossClusterSearchConnections(DescribeOutboundCrossClusterSearchConnectionsPublisher.this.firstRequest);
            }
            return DescribeOutboundCrossClusterSearchConnectionsPublisher.this.client.describeOutboundCrossClusterSearchConnections((DescribeOutboundCrossClusterSearchConnectionsRequest)((Object)DescribeOutboundCrossClusterSearchConnectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

