/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchClient;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryResponse;

public class GetUpgradeHistoryIterable
implements SdkIterable<GetUpgradeHistoryResponse> {
    private final ElasticsearchClient client;
    private final GetUpgradeHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetUpgradeHistoryIterable(ElasticsearchClient client, GetUpgradeHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetUpgradeHistoryResponseFetcher();
    }

    public Iterator<GetUpgradeHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final GetUpgradeHistoryIterable resume(GetUpgradeHistoryResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetUpgradeHistoryIterable(this.client, (GetUpgradeHistoryRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetUpgradeHistoryIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetUpgradeHistoryResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetUpgradeHistoryResponseFetcher
    implements SyncPageFetcher<GetUpgradeHistoryResponse> {
        private GetUpgradeHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetUpgradeHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetUpgradeHistoryResponse nextPage(GetUpgradeHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetUpgradeHistoryIterable.this.client.getUpgradeHistory(GetUpgradeHistoryIterable.this.firstRequest);
            }
            return GetUpgradeHistoryIterable.this.client.getUpgradeHistory((GetUpgradeHistoryRequest)((Object)GetUpgradeHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

