/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchClient;
import software.amazon.awssdk.services.elasticsearch.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticsearch.model.AddTagsResponse;
import software.amazon.awssdk.services.elasticsearch.model.BaseException;
import software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateRequest;
import software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse;
import software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchServiceRoleRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchServiceRoleResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse;
import software.amazon.awssdk.services.elasticsearch.model.DisabledOperationException;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchException;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryResponse;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusResponse;
import software.amazon.awssdk.services.elasticsearch.model.InternalException;
import software.amazon.awssdk.services.elasticsearch.model.InvalidTypeException;
import software.amazon.awssdk.services.elasticsearch.model.LimitExceededException;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListTagsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListTagsResponse;
import software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingRequest;
import software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse;
import software.amazon.awssdk.services.elasticsearch.model.RemoveTagsRequest;
import software.amazon.awssdk.services.elasticsearch.model.RemoveTagsResponse;
import software.amazon.awssdk.services.elasticsearch.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.elasticsearch.model.ResourceNotFoundException;
import software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateRequest;
import software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse;
import software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigRequest;
import software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigResponse;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.ValidationException;
import software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstanceOfferingsIterable;
import software.amazon.awssdk.services.elasticsearch.paginators.DescribeReservedElasticsearchInstancesIterable;
import software.amazon.awssdk.services.elasticsearch.paginators.GetUpgradeHistoryIterable;
import software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchInstanceTypesIterable;
import software.amazon.awssdk.services.elasticsearch.paginators.ListElasticsearchVersionsIterable;
import software.amazon.awssdk.services.elasticsearch.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.CancelElasticsearchServiceSoftwareUpdateRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.CreateElasticsearchDomainRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DeleteElasticsearchDomainRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DeleteElasticsearchServiceRoleRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchDomainConfigRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchDomainRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchDomainsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchInstanceTypeLimitsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeReservedElasticsearchInstanceOfferingsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeReservedElasticsearchInstancesRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.GetCompatibleElasticsearchVersionsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.GetUpgradeHistoryRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.GetUpgradeStatusRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListDomainNamesRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListElasticsearchInstanceTypesRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListElasticsearchVersionsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.PurchaseReservedElasticsearchInstanceOfferingRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.StartElasticsearchServiceSoftwareUpdateRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.UpdateElasticsearchDomainConfigRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.UpgradeElasticsearchDomainRequestMarshaller;

@SdkInternalApi
final class DefaultElasticsearchClient
implements ElasticsearchClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultElasticsearchClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "es";
    }

    @Override
    public AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws BaseException, LimitExceededException, ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AddTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsRequest).withMarshaller((Marshaller)new AddTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CancelElasticsearchServiceSoftwareUpdateResponse cancelElasticsearchServiceSoftwareUpdate(CancelElasticsearchServiceSoftwareUpdateRequest cancelElasticsearchServiceSoftwareUpdateRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelElasticsearchServiceSoftwareUpdateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CancelElasticsearchServiceSoftwareUpdateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelElasticsearchServiceSoftwareUpdate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelElasticsearchServiceSoftwareUpdateRequest).withMarshaller((Marshaller)new CancelElasticsearchServiceSoftwareUpdateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateElasticsearchDomainResponse createElasticsearchDomain(CreateElasticsearchDomainRequest createElasticsearchDomainRequest) throws BaseException, DisabledOperationException, InternalException, InvalidTypeException, LimitExceededException, ResourceAlreadyExistsException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateElasticsearchDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateElasticsearchDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateElasticsearchDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createElasticsearchDomainRequest).withMarshaller((Marshaller)new CreateElasticsearchDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteElasticsearchDomainResponse deleteElasticsearchDomain(DeleteElasticsearchDomainRequest deleteElasticsearchDomainRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteElasticsearchDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteElasticsearchDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteElasticsearchDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteElasticsearchDomainRequest).withMarshaller((Marshaller)new DeleteElasticsearchDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteElasticsearchServiceRoleResponse deleteElasticsearchServiceRole(DeleteElasticsearchServiceRoleRequest deleteElasticsearchServiceRoleRequest) throws BaseException, InternalException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteElasticsearchServiceRoleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteElasticsearchServiceRoleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteElasticsearchServiceRole").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteElasticsearchServiceRoleRequest).withMarshaller((Marshaller)new DeleteElasticsearchServiceRoleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeElasticsearchDomainResponse describeElasticsearchDomain(DescribeElasticsearchDomainRequest describeElasticsearchDomainRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeElasticsearchDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeElasticsearchDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeElasticsearchDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeElasticsearchDomainRequest).withMarshaller((Marshaller)new DescribeElasticsearchDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeElasticsearchDomainConfigResponse describeElasticsearchDomainConfig(DescribeElasticsearchDomainConfigRequest describeElasticsearchDomainConfigRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeElasticsearchDomainConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeElasticsearchDomainConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeElasticsearchDomainConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeElasticsearchDomainConfigRequest).withMarshaller((Marshaller)new DescribeElasticsearchDomainConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeElasticsearchDomainsResponse describeElasticsearchDomains(DescribeElasticsearchDomainsRequest describeElasticsearchDomainsRequest) throws BaseException, InternalException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeElasticsearchDomainsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeElasticsearchDomainsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeElasticsearchDomains").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeElasticsearchDomainsRequest).withMarshaller((Marshaller)new DescribeElasticsearchDomainsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeElasticsearchInstanceTypeLimitsResponse describeElasticsearchInstanceTypeLimits(DescribeElasticsearchInstanceTypeLimitsRequest describeElasticsearchInstanceTypeLimitsRequest) throws BaseException, InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeElasticsearchInstanceTypeLimitsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeElasticsearchInstanceTypeLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeElasticsearchInstanceTypeLimits").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeElasticsearchInstanceTypeLimitsRequest).withMarshaller((Marshaller)new DescribeElasticsearchInstanceTypeLimitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeReservedElasticsearchInstanceOfferingsResponse describeReservedElasticsearchInstanceOfferings(DescribeReservedElasticsearchInstanceOfferingsRequest describeReservedElasticsearchInstanceOfferingsRequest) throws ResourceNotFoundException, ValidationException, DisabledOperationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReservedElasticsearchInstanceOfferingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeReservedElasticsearchInstanceOfferingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservedElasticsearchInstanceOfferings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReservedElasticsearchInstanceOfferingsRequest).withMarshaller((Marshaller)new DescribeReservedElasticsearchInstanceOfferingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeReservedElasticsearchInstanceOfferingsIterable describeReservedElasticsearchInstanceOfferingsPaginator(DescribeReservedElasticsearchInstanceOfferingsRequest describeReservedElasticsearchInstanceOfferingsRequest) throws ResourceNotFoundException, ValidationException, DisabledOperationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        return new DescribeReservedElasticsearchInstanceOfferingsIterable(this, this.applyPaginatorUserAgent(describeReservedElasticsearchInstanceOfferingsRequest));
    }

    @Override
    public DescribeReservedElasticsearchInstancesResponse describeReservedElasticsearchInstances(DescribeReservedElasticsearchInstancesRequest describeReservedElasticsearchInstancesRequest) throws ResourceNotFoundException, InternalException, ValidationException, DisabledOperationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReservedElasticsearchInstancesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeReservedElasticsearchInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservedElasticsearchInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReservedElasticsearchInstancesRequest).withMarshaller((Marshaller)new DescribeReservedElasticsearchInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeReservedElasticsearchInstancesIterable describeReservedElasticsearchInstancesPaginator(DescribeReservedElasticsearchInstancesRequest describeReservedElasticsearchInstancesRequest) throws ResourceNotFoundException, InternalException, ValidationException, DisabledOperationException, AwsServiceException, SdkClientException, ElasticsearchException {
        return new DescribeReservedElasticsearchInstancesIterable(this, this.applyPaginatorUserAgent(describeReservedElasticsearchInstancesRequest));
    }

    @Override
    public GetCompatibleElasticsearchVersionsResponse getCompatibleElasticsearchVersions(GetCompatibleElasticsearchVersionsRequest getCompatibleElasticsearchVersionsRequest) throws BaseException, ResourceNotFoundException, DisabledOperationException, ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCompatibleElasticsearchVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetCompatibleElasticsearchVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCompatibleElasticsearchVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCompatibleElasticsearchVersionsRequest).withMarshaller((Marshaller)new GetCompatibleElasticsearchVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetUpgradeHistoryResponse getUpgradeHistory(GetUpgradeHistoryRequest getUpgradeHistoryRequest) throws BaseException, ResourceNotFoundException, DisabledOperationException, ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUpgradeHistoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetUpgradeHistoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUpgradeHistory").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getUpgradeHistoryRequest).withMarshaller((Marshaller)new GetUpgradeHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetUpgradeHistoryIterable getUpgradeHistoryPaginator(GetUpgradeHistoryRequest getUpgradeHistoryRequest) throws BaseException, ResourceNotFoundException, DisabledOperationException, ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        return new GetUpgradeHistoryIterable(this, this.applyPaginatorUserAgent(getUpgradeHistoryRequest));
    }

    @Override
    public GetUpgradeStatusResponse getUpgradeStatus(GetUpgradeStatusRequest getUpgradeStatusRequest) throws BaseException, ResourceNotFoundException, DisabledOperationException, ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUpgradeStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetUpgradeStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUpgradeStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getUpgradeStatusRequest).withMarshaller((Marshaller)new GetUpgradeStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDomainNamesResponse listDomainNames(ListDomainNamesRequest listDomainNamesRequest) throws BaseException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDomainNamesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDomainNamesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomainNames").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDomainNamesRequest).withMarshaller((Marshaller)new ListDomainNamesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListElasticsearchInstanceTypesResponse listElasticsearchInstanceTypes(ListElasticsearchInstanceTypesRequest listElasticsearchInstanceTypesRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListElasticsearchInstanceTypesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListElasticsearchInstanceTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListElasticsearchInstanceTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listElasticsearchInstanceTypesRequest).withMarshaller((Marshaller)new ListElasticsearchInstanceTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListElasticsearchInstanceTypesIterable listElasticsearchInstanceTypesPaginator(ListElasticsearchInstanceTypesRequest listElasticsearchInstanceTypesRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        return new ListElasticsearchInstanceTypesIterable(this, this.applyPaginatorUserAgent(listElasticsearchInstanceTypesRequest));
    }

    @Override
    public ListElasticsearchVersionsResponse listElasticsearchVersions(ListElasticsearchVersionsRequest listElasticsearchVersionsRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListElasticsearchVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListElasticsearchVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListElasticsearchVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listElasticsearchVersionsRequest).withMarshaller((Marshaller)new ListElasticsearchVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListElasticsearchVersionsIterable listElasticsearchVersionsPaginator(ListElasticsearchVersionsRequest listElasticsearchVersionsRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        return new ListElasticsearchVersionsIterable(this, this.applyPaginatorUserAgent(listElasticsearchVersionsRequest));
    }

    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws BaseException, ResourceNotFoundException, ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsRequest).withMarshaller((Marshaller)new ListTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PurchaseReservedElasticsearchInstanceOfferingResponse purchaseReservedElasticsearchInstanceOffering(PurchaseReservedElasticsearchInstanceOfferingRequest purchaseReservedElasticsearchInstanceOfferingRequest) throws ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException, DisabledOperationException, ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PurchaseReservedElasticsearchInstanceOfferingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PurchaseReservedElasticsearchInstanceOfferingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PurchaseReservedElasticsearchInstanceOffering").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)purchaseReservedElasticsearchInstanceOfferingRequest).withMarshaller((Marshaller)new PurchaseReservedElasticsearchInstanceOfferingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RemoveTagsResponse removeTags(RemoveTagsRequest removeTagsRequest) throws BaseException, ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RemoveTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsRequest).withMarshaller((Marshaller)new RemoveTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartElasticsearchServiceSoftwareUpdateResponse startElasticsearchServiceSoftwareUpdate(StartElasticsearchServiceSoftwareUpdateRequest startElasticsearchServiceSoftwareUpdateRequest) throws BaseException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartElasticsearchServiceSoftwareUpdateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartElasticsearchServiceSoftwareUpdateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartElasticsearchServiceSoftwareUpdate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startElasticsearchServiceSoftwareUpdateRequest).withMarshaller((Marshaller)new StartElasticsearchServiceSoftwareUpdateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateElasticsearchDomainConfigResponse updateElasticsearchDomainConfig(UpdateElasticsearchDomainConfigRequest updateElasticsearchDomainConfigRequest) throws BaseException, InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateElasticsearchDomainConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateElasticsearchDomainConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateElasticsearchDomainConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateElasticsearchDomainConfigRequest).withMarshaller((Marshaller)new UpdateElasticsearchDomainConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpgradeElasticsearchDomainResponse upgradeElasticsearchDomain(UpgradeElasticsearchDomainRequest upgradeElasticsearchDomainRequest) throws BaseException, ResourceNotFoundException, ResourceAlreadyExistsException, DisabledOperationException, ValidationException, InternalException, AwsServiceException, SdkClientException, ElasticsearchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpgradeElasticsearchDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpgradeElasticsearchDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpgradeElasticsearchDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)upgradeElasticsearchDomainRequest).withMarshaller((Marshaller)new UpgradeElasticsearchDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ElasticsearchException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("DisabledOperationException").exceptionBuilderSupplier(DisabledOperationException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTypeException").exceptionBuilderSupplier(InvalidTypeException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalException").exceptionBuilderSupplier(InternalException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends ElasticsearchRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.3.4").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ElasticsearchRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

