/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchAsyncClient;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse;

public class DescribeReservedElasticsearchInstancesPublisher
implements SdkPublisher<DescribeReservedElasticsearchInstancesResponse> {
    private final ElasticsearchAsyncClient client;
    private final DescribeReservedElasticsearchInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReservedElasticsearchInstancesPublisher(ElasticsearchAsyncClient client, DescribeReservedElasticsearchInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReservedElasticsearchInstancesPublisher(ElasticsearchAsyncClient client, DescribeReservedElasticsearchInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReservedElasticsearchInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReservedElasticsearchInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final DescribeReservedElasticsearchInstancesPublisher resume(DescribeReservedElasticsearchInstancesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReservedElasticsearchInstancesPublisher(this.client, (DescribeReservedElasticsearchInstancesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeReservedElasticsearchInstancesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeReservedElasticsearchInstancesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeReservedElasticsearchInstancesResponseFetcher
    implements AsyncPageFetcher<DescribeReservedElasticsearchInstancesResponse> {
        private DescribeReservedElasticsearchInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedElasticsearchInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeReservedElasticsearchInstancesResponse> nextPage(DescribeReservedElasticsearchInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedElasticsearchInstancesPublisher.this.client.describeReservedElasticsearchInstances(DescribeReservedElasticsearchInstancesPublisher.this.firstRequest);
            }
            return DescribeReservedElasticsearchInstancesPublisher.this.client.describeReservedElasticsearchInstances((DescribeReservedElasticsearchInstancesRequest)((Object)DescribeReservedElasticsearchInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

