/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelledChangeProperty
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CancelledChangeProperty> {
    private static final SdkField<String> PROPERTY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PropertyName").getter(CancelledChangeProperty.getter(CancelledChangeProperty::propertyName)).setter(CancelledChangeProperty.setter(Builder::propertyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyName").build()}).build();
    private static final SdkField<String> CANCELLED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CancelledValue").getter(CancelledChangeProperty.getter(CancelledChangeProperty::cancelledValue)).setter(CancelledChangeProperty.setter(Builder::cancelledValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CancelledValue").build()}).build();
    private static final SdkField<String> ACTIVE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActiveValue").getter(CancelledChangeProperty.getter(CancelledChangeProperty::activeValue)).setter(CancelledChangeProperty.setter(Builder::activeValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_NAME_FIELD, CANCELLED_VALUE_FIELD, ACTIVE_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String propertyName;
    private final String cancelledValue;
    private final String activeValue;

    private CancelledChangeProperty(BuilderImpl builder) {
        this.propertyName = builder.propertyName;
        this.cancelledValue = builder.cancelledValue;
        this.activeValue = builder.activeValue;
    }

    public final String propertyName() {
        return this.propertyName;
    }

    public final String cancelledValue() {
        return this.cancelledValue;
    }

    public final String activeValue() {
        return this.activeValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cancelledValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelledChangeProperty)) {
            return false;
        }
        CancelledChangeProperty other = (CancelledChangeProperty)obj;
        return Objects.equals(this.propertyName(), other.propertyName()) && Objects.equals(this.cancelledValue(), other.cancelledValue()) && Objects.equals(this.activeValue(), other.activeValue());
    }

    public final String toString() {
        return ToString.builder((String)"CancelledChangeProperty").add("PropertyName", (Object)this.propertyName()).add("CancelledValue", (Object)this.cancelledValue()).add("ActiveValue", (Object)this.activeValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PropertyName": {
                return Optional.ofNullable(clazz.cast(this.propertyName()));
            }
            case "CancelledValue": {
                return Optional.ofNullable(clazz.cast(this.cancelledValue()));
            }
            case "ActiveValue": {
                return Optional.ofNullable(clazz.cast(this.activeValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelledChangeProperty, T> g) {
        return obj -> g.apply((CancelledChangeProperty)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String propertyName;
        private String cancelledValue;
        private String activeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelledChangeProperty model) {
            this.propertyName(model.propertyName);
            this.cancelledValue(model.cancelledValue);
            this.activeValue(model.activeValue);
        }

        public final String getPropertyName() {
            return this.propertyName;
        }

        public final void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public final Builder propertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public final String getCancelledValue() {
            return this.cancelledValue;
        }

        public final void setCancelledValue(String cancelledValue) {
            this.cancelledValue = cancelledValue;
        }

        @Override
        public final Builder cancelledValue(String cancelledValue) {
            this.cancelledValue = cancelledValue;
            return this;
        }

        public final String getActiveValue() {
            return this.activeValue;
        }

        public final void setActiveValue(String activeValue) {
            this.activeValue = activeValue;
        }

        @Override
        public final Builder activeValue(String activeValue) {
            this.activeValue = activeValue;
            return this;
        }

        public CancelledChangeProperty build() {
            return new CancelledChangeProperty(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CancelledChangeProperty> {
        public Builder propertyName(String var1);

        public Builder cancelledValue(String var1);

        public Builder activeValue(String var1);
    }
}

