/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.elasticsearch.DefaultElasticsearchAsyncClient;
import software.amazon.awssdk.services.elasticsearch.DefaultElasticsearchBaseClientBuilder;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchAsyncClient;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchAsyncClientBuilder;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchServiceClientConfiguration;
import software.amazon.awssdk.services.elasticsearch.endpoints.ElasticsearchEndpointProvider;

@SdkInternalApi
final class DefaultElasticsearchAsyncClientBuilder
extends DefaultElasticsearchBaseClientBuilder<ElasticsearchAsyncClientBuilder, ElasticsearchAsyncClient>
implements ElasticsearchAsyncClientBuilder {
    DefaultElasticsearchAsyncClientBuilder() {
    }

    @Override
    public DefaultElasticsearchAsyncClientBuilder endpointProvider(ElasticsearchEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ElasticsearchAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultElasticsearchAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ElasticsearchServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultElasticsearchAsyncClient client = new DefaultElasticsearchAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ElasticsearchServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ElasticsearchServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

