/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.elasticsearch.DefaultElasticsearchBaseClientBuilder;
import software.amazon.awssdk.services.elasticsearch.DefaultElasticsearchClient;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchClient;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchClientBuilder;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchServiceClientConfiguration;
import software.amazon.awssdk.services.elasticsearch.endpoints.ElasticsearchEndpointProvider;

@SdkInternalApi
final class DefaultElasticsearchClientBuilder
extends DefaultElasticsearchBaseClientBuilder<ElasticsearchClientBuilder, ElasticsearchClient>
implements ElasticsearchClientBuilder {
    DefaultElasticsearchClientBuilder() {
    }

    @Override
    public DefaultElasticsearchClientBuilder endpointProvider(ElasticsearchEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ElasticsearchClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultElasticsearchClientBuilder.validateClientOptions(clientConfiguration);
        ElasticsearchServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultElasticsearchClient client = new DefaultElasticsearchClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ElasticsearchServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ElasticsearchServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

