/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchRequest;
import software.amazon.awssdk.services.elasticsearch.model.PackageSource;
import software.amazon.awssdk.services.elasticsearch.model.PackageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePackageRequest
extends ElasticsearchRequest
implements ToCopyableBuilder<Builder, CreatePackageRequest> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageName").getter(CreatePackageRequest.getter(CreatePackageRequest::packageName)).setter(CreatePackageRequest.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()}).build();
    private static final SdkField<String> PACKAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageType").getter(CreatePackageRequest.getter(CreatePackageRequest::packageTypeAsString)).setter(CreatePackageRequest.setter(Builder::packageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageType").build()}).build();
    private static final SdkField<String> PACKAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageDescription").getter(CreatePackageRequest.getter(CreatePackageRequest::packageDescription)).setter(CreatePackageRequest.setter(Builder::packageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageDescription").build()}).build();
    private static final SdkField<PackageSource> PACKAGE_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PackageSource").getter(CreatePackageRequest.getter(CreatePackageRequest::packageSource)).setter(CreatePackageRequest.setter(Builder::packageSource)).constructor(PackageSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD, PACKAGE_TYPE_FIELD, PACKAGE_DESCRIPTION_FIELD, PACKAGE_SOURCE_FIELD));
    private final String packageName;
    private final String packageType;
    private final String packageDescription;
    private final PackageSource packageSource;

    private CreatePackageRequest(BuilderImpl builder) {
        super(builder);
        this.packageName = builder.packageName;
        this.packageType = builder.packageType;
        this.packageDescription = builder.packageDescription;
        this.packageSource = builder.packageSource;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final PackageType packageType() {
        return PackageType.fromValue(this.packageType);
    }

    public final String packageTypeAsString() {
        return this.packageType;
    }

    public final String packageDescription() {
        return this.packageDescription;
    }

    public final PackageSource packageSource() {
        return this.packageSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePackageRequest)) {
            return false;
        }
        CreatePackageRequest other = (CreatePackageRequest)((Object)obj);
        return Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.packageTypeAsString(), other.packageTypeAsString()) && Objects.equals(this.packageDescription(), other.packageDescription()) && Objects.equals(this.packageSource(), other.packageSource());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePackageRequest").add("PackageName", (Object)this.packageName()).add("PackageType", (Object)this.packageTypeAsString()).add("PackageDescription", (Object)this.packageDescription()).add("PackageSource", (Object)this.packageSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PackageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "PackageType": {
                return Optional.ofNullable(clazz.cast(this.packageTypeAsString()));
            }
            case "PackageDescription": {
                return Optional.ofNullable(clazz.cast(this.packageDescription()));
            }
            case "PackageSource": {
                return Optional.ofNullable(clazz.cast(this.packageSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePackageRequest, T> g) {
        return obj -> g.apply((CreatePackageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchRequest.BuilderImpl
    implements Builder {
        private String packageName;
        private String packageType;
        private String packageDescription;
        private PackageSource packageSource;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePackageRequest model) {
            super(model);
            this.packageName(model.packageName);
            this.packageType(model.packageType);
            this.packageDescription(model.packageDescription);
            this.packageSource(model.packageSource);
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageType() {
            return this.packageType;
        }

        public final void setPackageType(String packageType) {
            this.packageType = packageType;
        }

        @Override
        public final Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        @Override
        public final Builder packageType(PackageType packageType) {
            this.packageType(packageType == null ? null : packageType.toString());
            return this;
        }

        public final String getPackageDescription() {
            return this.packageDescription;
        }

        public final void setPackageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
        }

        @Override
        public final Builder packageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
            return this;
        }

        public final PackageSource.Builder getPackageSource() {
            return this.packageSource != null ? this.packageSource.toBuilder() : null;
        }

        public final void setPackageSource(PackageSource.BuilderImpl packageSource) {
            this.packageSource = packageSource != null ? packageSource.build() : null;
        }

        @Override
        public final Builder packageSource(PackageSource packageSource) {
            this.packageSource = packageSource;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePackageRequest build() {
            return new CreatePackageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticsearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePackageRequest> {
        public Builder packageName(String var1);

        public Builder packageType(String var1);

        public Builder packageType(PackageType var1);

        public Builder packageDescription(String var1);

        public Builder packageSource(PackageSource var1);

        default public Builder packageSource(Consumer<PackageSource.Builder> packageSource) {
            return this.packageSource((PackageSource)((PackageSource.Builder)PackageSource.builder().applyMutation(packageSource)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

