/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutoTuneState {
    ENABLED("ENABLED"),
    DISABLED("DISABLED"),
    ENABLE_IN_PROGRESS("ENABLE_IN_PROGRESS"),
    DISABLE_IN_PROGRESS("DISABLE_IN_PROGRESS"),
    DISABLED_AND_ROLLBACK_SCHEDULED("DISABLED_AND_ROLLBACK_SCHEDULED"),
    DISABLED_AND_ROLLBACK_IN_PROGRESS("DISABLED_AND_ROLLBACK_IN_PROGRESS"),
    DISABLED_AND_ROLLBACK_COMPLETE("DISABLED_AND_ROLLBACK_COMPLETE"),
    DISABLED_AND_ROLLBACK_ERROR("DISABLED_AND_ROLLBACK_ERROR"),
    ERROR("ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutoTuneState> VALUE_MAP;
    private final String value;

    private AutoTuneState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoTuneState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoTuneState> knownValues() {
        EnumSet<AutoTuneState> knownValues = EnumSet.allOf(AutoTuneState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutoTuneState.class, AutoTuneState::toString);
    }
}

