/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeHistory;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeHistoryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUpgradeHistoryResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, GetUpgradeHistoryResponse> {
    private static final SdkField<List<UpgradeHistory>> UPGRADE_HISTORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UpgradeHistories").getter(GetUpgradeHistoryResponse.getter(GetUpgradeHistoryResponse::upgradeHistories)).setter(GetUpgradeHistoryResponse.setter(Builder::upgradeHistories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeHistories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpgradeHistory::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetUpgradeHistoryResponse.getter(GetUpgradeHistoryResponse::nextToken)).setter(GetUpgradeHistoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPGRADE_HISTORIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<UpgradeHistory> upgradeHistories;
    private final String nextToken;

    private GetUpgradeHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.upgradeHistories = builder.upgradeHistories;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasUpgradeHistories() {
        return this.upgradeHistories != null && !(this.upgradeHistories instanceof SdkAutoConstructList);
    }

    public final List<UpgradeHistory> upgradeHistories() {
        return this.upgradeHistories;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpgradeHistories() ? this.upgradeHistories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUpgradeHistoryResponse)) {
            return false;
        }
        GetUpgradeHistoryResponse other = (GetUpgradeHistoryResponse)((Object)obj);
        return this.hasUpgradeHistories() == other.hasUpgradeHistories() && Objects.equals(this.upgradeHistories(), other.upgradeHistories()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetUpgradeHistoryResponse").add("UpgradeHistories", this.hasUpgradeHistories() ? this.upgradeHistories() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UpgradeHistories": {
                return Optional.ofNullable(clazz.cast(this.upgradeHistories()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUpgradeHistoryResponse, T> g) {
        return obj -> g.apply((GetUpgradeHistoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private List<UpgradeHistory> upgradeHistories = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUpgradeHistoryResponse model) {
            super(model);
            this.upgradeHistories(model.upgradeHistories);
            this.nextToken(model.nextToken);
        }

        public final List<UpgradeHistory.Builder> getUpgradeHistories() {
            List<UpgradeHistory.Builder> result = UpgradeHistoryListCopier.copyToBuilder(this.upgradeHistories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder upgradeHistories(Collection<UpgradeHistory> upgradeHistories) {
            this.upgradeHistories = UpgradeHistoryListCopier.copy(upgradeHistories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder upgradeHistories(UpgradeHistory ... upgradeHistories) {
            this.upgradeHistories(Arrays.asList(upgradeHistories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder upgradeHistories(Consumer<UpgradeHistory.Builder> ... upgradeHistories) {
            this.upgradeHistories(Stream.of(upgradeHistories).map(c -> (UpgradeHistory)((UpgradeHistory.Builder)UpgradeHistory.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUpgradeHistories(Collection<UpgradeHistory.BuilderImpl> upgradeHistories) {
            this.upgradeHistories = UpgradeHistoryListCopier.copyFromBuilder(upgradeHistories);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetUpgradeHistoryResponse build() {
            return new GetUpgradeHistoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticsearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUpgradeHistoryResponse> {
        public Builder upgradeHistories(Collection<UpgradeHistory> var1);

        public Builder upgradeHistories(UpgradeHistory ... var1);

        public Builder upgradeHistories(Consumer<UpgradeHistory.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

