/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.elasticsearch.model.VPCDerivedInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VPCDerivedInfoMarshaller {
    private static final MarshallingInfo<String> VPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VPCId").isBinary(false).build();
    private static final MarshallingInfo<List> SUBNETIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetIds").isBinary(false).build();
    private static final MarshallingInfo<List> AVAILABILITYZONES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZones").isBinary(false).build();
    private static final MarshallingInfo<List> SECURITYGROUPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroupIds").isBinary(false).build();
    private static final VPCDerivedInfoMarshaller INSTANCE = new VPCDerivedInfoMarshaller();

    private VPCDerivedInfoMarshaller() {
    }

    public static VPCDerivedInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VPCDerivedInfo vpcDerivedInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)vpcDerivedInfo, (String)"vpcDerivedInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)vpcDerivedInfo.vpcId(), VPCID_BINDING);
            protocolMarshaller.marshall(vpcDerivedInfo.subnetIds(), SUBNETIDS_BINDING);
            protocolMarshaller.marshall(vpcDerivedInfo.availabilityZones(), AVAILABILITYZONES_BINDING);
            protocolMarshaller.marshall(vpcDerivedInfo.securityGroupIds(), SECURITYGROUPIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

