/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticsearch.model.StorageTypeLimit;

public class StorageTypeLimitUnmarshaller
implements Unmarshaller<StorageTypeLimit, JsonUnmarshallerContext> {
    private static final StorageTypeLimitUnmarshaller INSTANCE = new StorageTypeLimitUnmarshaller();

    public StorageTypeLimit unmarshall(JsonUnmarshallerContext context) throws Exception {
        StorageTypeLimit.Builder storageTypeLimitBuilder = StorageTypeLimit.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("LimitName", targetDepth)) {
                    context.nextToken();
                    storageTypeLimitBuilder.limitName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LimitValues", targetDepth)) {
                    context.nextToken();
                    storageTypeLimitBuilder.limitValues(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (StorageTypeLimit)storageTypeLimitBuilder.build();
    }

    public static StorageTypeLimitUnmarshaller getInstance() {
        return INSTANCE;
    }
}

