/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.elasticsearch.model.LogPublishingOption;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LogPublishingOptionMarshaller {
    private static final MarshallingInfo<String> CLOUDWATCHLOGSLOGGROUPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchLogsLogGroupArn").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();
    private static final LogPublishingOptionMarshaller INSTANCE = new LogPublishingOptionMarshaller();

    private LogPublishingOptionMarshaller() {
    }

    public static LogPublishingOptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LogPublishingOption logPublishingOption, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)logPublishingOption, (String)"logPublishingOption");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)logPublishingOption.cloudWatchLogsLogGroupArn(), CLOUDWATCHLOGSLOGGROUPARN_BINDING);
            protocolMarshaller.marshall((Object)logPublishingOption.enabled(), ENABLED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

