/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.Limits;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LimitsMarshaller {
    private static final MarshallingInfo<List> STORAGETYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageTypes").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INSTANCELIMITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceLimits").isBinary(false).build();
    private static final MarshallingInfo<List> ADDITIONALLIMITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdditionalLimits").isBinary(false).build();
    private static final LimitsMarshaller INSTANCE = new LimitsMarshaller();

    private LimitsMarshaller() {
    }

    public static LimitsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Limits limits, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)limits, (String)"limits");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(limits.storageTypes(), STORAGETYPES_BINDING);
            protocolMarshaller.marshall((Object)limits.instanceLimits(), INSTANCELIMITS_BINDING);
            protocolMarshaller.marshall(limits.additionalLimits(), ADDITIONALLIMITS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

