/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchVersionStatus;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ElasticsearchVersionStatusMarshaller {
    private static final MarshallingInfo<String> OPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Options").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final ElasticsearchVersionStatusMarshaller INSTANCE = new ElasticsearchVersionStatusMarshaller();

    private ElasticsearchVersionStatusMarshaller() {
    }

    public static ElasticsearchVersionStatusMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ElasticsearchVersionStatus elasticsearchVersionStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)elasticsearchVersionStatus, (String)"elasticsearchVersionStatus");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)elasticsearchVersionStatus.options(), OPTIONS_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchVersionStatus.status(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

