/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfigStatus;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ElasticsearchClusterConfigStatusMarshaller {
    private static final MarshallingInfo<StructuredPojo> OPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Options").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final ElasticsearchClusterConfigStatusMarshaller INSTANCE = new ElasticsearchClusterConfigStatusMarshaller();

    private ElasticsearchClusterConfigStatusMarshaller() {
    }

    public static ElasticsearchClusterConfigStatusMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ElasticsearchClusterConfigStatus elasticsearchClusterConfigStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)elasticsearchClusterConfigStatus, (String)"elasticsearchClusterConfigStatus");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)elasticsearchClusterConfigStatus.options(), OPTIONS_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchClusterConfigStatus.status(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

