/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.EBSOptionsStatus;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EBSOptionsStatusMarshaller {
    private static final MarshallingInfo<StructuredPojo> OPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Options").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final EBSOptionsStatusMarshaller INSTANCE = new EBSOptionsStatusMarshaller();

    private EBSOptionsStatusMarshaller() {
    }

    public static EBSOptionsStatusMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EBSOptionsStatus ebsOptionsStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ebsOptionsStatus, (String)"ebsOptionsStatus");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ebsOptionsStatus.options(), OPTIONS_BINDING);
            protocolMarshaller.marshall((Object)ebsOptionsStatus.status(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

