/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticsearch.model.DomainInfo;

public class DomainInfoUnmarshaller
implements Unmarshaller<DomainInfo, JsonUnmarshallerContext> {
    private static final DomainInfoUnmarshaller INSTANCE = new DomainInfoUnmarshaller();

    public DomainInfo unmarshall(JsonUnmarshallerContext context) throws Exception {
        DomainInfo.Builder domainInfoBuilder = DomainInfo.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("DomainName", targetDepth)) {
                    context.nextToken();
                    domainInfoBuilder.domainName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DomainInfo)domainInfoBuilder.build();
    }

    public static DomainInfoUnmarshaller getInstance() {
        return INSTANCE;
    }
}

