/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.AdvancedOptionsStatus;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AdvancedOptionsStatusMarshaller {
    private static final MarshallingInfo<Map> OPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Options").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final AdvancedOptionsStatusMarshaller INSTANCE = new AdvancedOptionsStatusMarshaller();

    private AdvancedOptionsStatusMarshaller() {
    }

    public static AdvancedOptionsStatusMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AdvancedOptionsStatus advancedOptionsStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)advancedOptionsStatus, (String)"advancedOptionsStatus");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(advancedOptionsStatus.options(), OPTIONS_BINDING);
            protocolMarshaller.marshall((Object)advancedOptionsStatus.status(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

