/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticsearch.model.VPCOptions;

public class VPCOptionsUnmarshaller
implements Unmarshaller<VPCOptions, JsonUnmarshallerContext> {
    private static final VPCOptionsUnmarshaller INSTANCE = new VPCOptionsUnmarshaller();

    public VPCOptions unmarshall(JsonUnmarshallerContext context) throws Exception {
        VPCOptions.Builder vpcOptionsBuilder = VPCOptions.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("SubnetIds", targetDepth)) {
                    context.nextToken();
                    vpcOptionsBuilder.subnetIds(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("SecurityGroupIds", targetDepth)) {
                    context.nextToken();
                    vpcOptionsBuilder.securityGroupIds(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (VPCOptions)vpcOptionsBuilder.build();
    }

    public static VPCOptionsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

