/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest;

@SdkInternalApi
public class ListElasticsearchInstanceTypesRequestModelMarshaller {
    private static final MarshallingInfo<String> ELASTICSEARCHVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("ElasticsearchVersion").build();
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("domainName").build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("maxResults").build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("nextToken").build();
    private static final ListElasticsearchInstanceTypesRequestModelMarshaller INSTANCE = new ListElasticsearchInstanceTypesRequestModelMarshaller();

    public static ListElasticsearchInstanceTypesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListElasticsearchInstanceTypesRequest listElasticsearchInstanceTypesRequest, ProtocolMarshaller protocolMarshaller) {
        if (listElasticsearchInstanceTypesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)listElasticsearchInstanceTypesRequest.elasticsearchVersion(), ELASTICSEARCHVERSION_BINDING);
            protocolMarshaller.marshall((Object)listElasticsearchInstanceTypesRequest.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall((Object)listElasticsearchInstanceTypesRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall((Object)listElasticsearchInstanceTypesRequest.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

