/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchClient;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse;

public final class ListElasticsearchVersionsPaginator
implements SdkIterable<ListElasticsearchVersionsResponse> {
    private final ElasticsearchClient client;
    private final ListElasticsearchVersionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListElasticsearchVersionsPaginator(ElasticsearchClient client, ListElasticsearchVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListElasticsearchVersionsResponseFetcher();
    }

    public Iterator<ListElasticsearchVersionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListElasticsearchVersionsResponseFetcher
    implements NextPageFetcher<ListElasticsearchVersionsResponse> {
        private ListElasticsearchVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListElasticsearchVersionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListElasticsearchVersionsResponse nextPage(ListElasticsearchVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListElasticsearchVersionsPaginator.this.client.listElasticsearchVersions(ListElasticsearchVersionsPaginator.this.firstRequest);
            }
            return ListElasticsearchVersionsPaginator.this.client.listElasticsearchVersions((ListElasticsearchVersionsRequest)((Object)ListElasticsearchVersionsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

