/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LogType {
    INDEX_SLOW_LOGS("INDEX_SLOW_LOGS"),
    SEARCH_SLOW_LOGS("SEARCH_SLOW_LOGS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LogType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LogType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LogType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LogType> knownValues() {
        return Stream.of(LogType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

