/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticsearch.model.VPCDerivedInfo;

public class VPCDerivedInfoUnmarshaller
implements Unmarshaller<VPCDerivedInfo, JsonUnmarshallerContext> {
    private static final VPCDerivedInfoUnmarshaller INSTANCE = new VPCDerivedInfoUnmarshaller();

    public VPCDerivedInfo unmarshall(JsonUnmarshallerContext context) throws Exception {
        VPCDerivedInfo.Builder vpcDerivedInfoBuilder = VPCDerivedInfo.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("VPCId", targetDepth)) {
                    context.nextToken();
                    vpcDerivedInfoBuilder.vpcId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SubnetIds", targetDepth)) {
                    context.nextToken();
                    vpcDerivedInfoBuilder.subnetIds(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("AvailabilityZones", targetDepth)) {
                    context.nextToken();
                    vpcDerivedInfoBuilder.availabilityZones(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("SecurityGroupIds", targetDepth)) {
                    context.nextToken();
                    vpcDerivedInfoBuilder.securityGroupIds(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (VPCDerivedInfo)vpcDerivedInfoBuilder.build();
    }

    public static VPCDerivedInfoUnmarshaller getInstance() {
        return INSTANCE;
    }
}

