/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.elasticsearch.model.StorageTypeLimit;

@SdkInternalApi
public class StorageTypeLimitMarshaller {
    private static final MarshallingInfo<String> LIMITNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LimitName").build();
    private static final MarshallingInfo<List> LIMITVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LimitValues").build();
    private static final StorageTypeLimitMarshaller INSTANCE = new StorageTypeLimitMarshaller();

    public static StorageTypeLimitMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StorageTypeLimit storageTypeLimit, ProtocolMarshaller protocolMarshaller) {
        if (storageTypeLimit == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)storageTypeLimit.limitName(), LIMITNAME_BINDING);
            protocolMarshaller.marshall(storageTypeLimit.limitValues(), LIMITVALUES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

