/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticsearch.model.InstanceCountLimits;

public class InstanceCountLimitsUnmarshaller
implements Unmarshaller<InstanceCountLimits, JsonUnmarshallerContext> {
    private static final InstanceCountLimitsUnmarshaller INSTANCE = new InstanceCountLimitsUnmarshaller();

    public InstanceCountLimits unmarshall(JsonUnmarshallerContext context) throws Exception {
        InstanceCountLimits.Builder instanceCountLimitsBuilder = InstanceCountLimits.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("MinimumInstanceCount", targetDepth)) {
                    context.nextToken();
                    instanceCountLimitsBuilder.minimumInstanceCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("MaximumInstanceCount", targetDepth)) {
                    context.nextToken();
                    instanceCountLimitsBuilder.maximumInstanceCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (InstanceCountLimits)instanceCountLimitsBuilder.build();
    }

    public static InstanceCountLimitsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

